/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.TransactionReportAcceptHeaderValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CardTransactionsReportByPeriodObject;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetCardTransactionsReportValidator
extends AbstractAccountTppValidator<CardTransactionsReportByPeriodObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final TransactionReportAcceptHeaderValidator transactionReportAcceptHeaderValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CardTransactionsReportByPeriodObject requestObject) {
        AccountConsent accountConsent = requestObject.getAccountConsent();
        if (accountConsent.isConsentWithNotCardAccount() && !accountConsent.isConsentForAllAvailableAccounts() && !accountConsent.isGlobalConsent()) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID);
        }
        ValidationResult acceptHeaderValidationResult = this.transactionReportAcceptHeaderValidator.validate(requestObject.getAcceptHeader());
        if (acceptHeaderValidationResult.isNotValid()) {
            return acceptHeaderValidationResult;
        }
        ValidationResult validationResult = this.validateCardTransactionReportParameters(requestObject.getDeltaList(), requestObject.getDateFrom());
        if (validationResult.isNotValid()) {
            return validationResult;
        }
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(accountConsent.getAspspAccess(), requestObject.getTransactions(), requestObject.getAccountId(), accountConsent.getAisConsentRequestType());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        BookingStatus bookingStatus = requestObject.getBookingStatus();
        if (this.isNotSupportedBookingStatus(bookingStatus)) {
            return ValidationResult.invalid(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PARAMETER_NOT_SUPPORTED_BOOKING_STATUS, (Object[])new Object[]{bookingStatus.getValue()}));
        }
        ValidationResult oauthConsentValidationResult = this.oauthConsentValidator.validate(accountConsent);
        if (oauthConsentValidationResult.isNotValid()) {
            return oauthConsentValidationResult;
        }
        return this.accountConsentValidator.validate(accountConsent, requestObject.getRequestUri());
    }

    private ValidationResult validateCardTransactionReportParameters(Boolean deltaList, LocalDate dateFrom) {
        boolean isAllParametersPresentAndSupported;
        ArrayList<TppMessageInformation> tppMessageInformationList = new ArrayList<TppMessageInformation>();
        boolean isNotSearchByPeriod = dateFrom == null;
        boolean isDeltaListSupported = this.aspspProfileService.isDeltaListSupported();
        boolean isDeltaListPresentInRequest = BooleanUtils.isTrue((Boolean)deltaList);
        if (this.isDeltaAccessParameterNotSupported(isDeltaListSupported, isNotSearchByPeriod)) {
            tppMessageInformationList.add(TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PARAMETER_NOT_SUPPORTED_DELTA_LIST));
        }
        boolean bl = isAllParametersPresentAndSupported = isDeltaListSupported && isDeltaListPresentInRequest;
        if (isAllParametersPresentAndSupported) {
            tppMessageInformationList.add(TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_MULTIPLE_DELTA_REPORT));
        }
        return tppMessageInformationList.isEmpty() ? ValidationResult.valid() : ValidationResult.invalid(ErrorType.AIS_400, tppMessageInformationList.toArray(new TppMessageInformation[0]));
    }

    private boolean isDeltaAccessParameterNotSupported(boolean isParameterSupportedInProfile, boolean isNotSearchByPeriod) {
        return !isParameterSupportedInProfile && isNotSearchByPeriod;
    }

    private boolean isNotSupportedBookingStatus(BookingStatus bookingStatus) {
        return !this.aspspProfileService.getAvailableBookingStatuses().contains(bookingStatus);
    }

    @ConstructorProperties(value={"accountConsentValidator", "aspspProfileService", "transactionReportAcceptHeaderValidator", "accountReferenceAccessValidator", "oauthConsentValidator"})
    public GetCardTransactionsReportValidator(AccountConsentValidator accountConsentValidator, AspspProfileServiceWrapper aspspProfileService, TransactionReportAcceptHeaderValidator transactionReportAcceptHeaderValidator, AccountReferenceAccessValidator accountReferenceAccessValidator, OauthConsentValidator oauthConsentValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.aspspProfileService = aspspProfileService;
        this.transactionReportAcceptHeaderValidator = transactionReportAcceptHeaderValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

