/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetAccountBalanceRequestObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetBalancesReportValidator
extends AbstractAccountTppValidator<GetAccountBalanceRequestObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetAccountBalanceRequestObject consentObject) {
        AccountConsent accountConsent = consentObject.getAccountConsent();
        if (accountConsent.isConsentWithNotIbanAccount() && !accountConsent.isConsentForAllAvailableAccounts() && !accountConsent.isGlobalConsent()) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID);
        }
        Xs2aAccountAccess accountAccess = accountConsent.getAspspAccess();
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(accountAccess, accountAccess.getBalances(), consentObject.getAccountId(), accountConsent.getAisConsentRequestType());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        ValidationResult oauthConsentValidationResult = this.oauthConsentValidator.validate(accountConsent);
        if (oauthConsentValidationResult.isNotValid()) {
            return oauthConsentValidationResult;
        }
        return this.accountConsentValidator.validate(accountConsent, consentObject.getRequestUri());
    }

    @ConstructorProperties(value={"accountConsentValidator", "accountReferenceAccessValidator", "oauthConsentValidator"})
    public GetBalancesReportValidator(AccountConsentValidator accountConsentValidator, AccountReferenceAccessValidator accountReferenceAccessValidator, OauthConsentValidator oauthConsentValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

