/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class Xs2aToSpiSinglePaymentMapper {
    private final Xs2aToSpiAmountMapper xs2aToSpiAmountMapper;
    private final Xs2aToSpiAddressMapper xs2aToSpiAddressMapper;
    private final Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper;
    private final Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper;
    private final RemittanceMapper remittanceMapper;

    public SpiSinglePayment mapToSpiSinglePayment(SinglePayment payment, String paymentProduct) {
        SpiSinglePayment single = new SpiSinglePayment(paymentProduct);
        single.setPaymentId(payment.getPaymentId());
        single.setEndToEndIdentification(payment.getEndToEndIdentification());
        single.setInstructionIdentification(payment.getInstructionIdentification());
        single.setDebtorAccount(this.xs2aToSpiAccountReferenceMapper.mapToSpiAccountReference(payment.getDebtorAccount()));
        single.setInstructedAmount(this.xs2aToSpiAmountMapper.mapToSpiAmount(payment.getInstructedAmount()));
        single.setCreditorAccount(this.xs2aToSpiAccountReferenceMapper.mapToSpiAccountReference(payment.getCreditorAccount()));
        if (payment.getTransactionStatus() != null) {
            single.setPaymentStatus(payment.getTransactionStatus());
        }
        single.setCreditorAgent(payment.getCreditorAgent());
        single.setCreditorName(payment.getCreditorName());
        single.setCreditorAddress(this.xs2aToSpiAddressMapper.mapToSpiAddress(payment.getCreditorAddress()));
        single.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        single.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        single.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        single.setPsuDataList(this.xs2aToSpiPsuDataMapper.mapToSpiPsuDataList(payment.getPsuDataList()));
        single.setStatusChangeTimestamp(payment.getStatusChangeTimestamp());
        single.setUltimateDebtor(payment.getUltimateDebtor());
        single.setUltimateCreditor(payment.getUltimateCreditor());
        single.setPurposeCode(payment.getPurposeCode());
        single.setRemittanceInformationStructured(this.remittanceMapper.mapToSpiRemittance(payment.getRemittanceInformationStructured()));
        single.setCreationTimestamp(payment.getCreationTimestamp());
        single.setContentType(payment.getContentType());
        return single;
    }

    @ConstructorProperties(value={"xs2aToSpiAmountMapper", "xs2aToSpiAddressMapper", "xs2aToSpiAccountReferenceMapper", "xs2aToSpiPsuDataMapper", "remittanceMapper"})
    public Xs2aToSpiSinglePaymentMapper(Xs2aToSpiAmountMapper xs2aToSpiAmountMapper, Xs2aToSpiAddressMapper xs2aToSpiAddressMapper, Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper, Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper, RemittanceMapper remittanceMapper) {
        this.xs2aToSpiAmountMapper = xs2aToSpiAmountMapper;
        this.xs2aToSpiAddressMapper = xs2aToSpiAddressMapper;
        this.xs2aToSpiAccountReferenceMapper = xs2aToSpiAccountReferenceMapper;
        this.xs2aToSpiPsuDataMapper = xs2aToSpiPsuDataMapper;
        this.remittanceMapper = remittanceMapper;
    }
}

