/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHeaderValidatorImpl {
    protected ErrorBuildingService errorBuildingService;

    AbstractHeaderValidatorImpl(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }

    protected abstract String getHeaderName();

    public void validate(Map<String, String> headers, MessageError messageError) {
        ValidationResult validationResult = this.validate(headers);
        if (validationResult.isNotValid()) {
            this.errorBuildingService.enrichMessageError(messageError, validationResult.getMessageError());
        }
    }

    protected ValidationResult validate(Map<String, String> headers) {
        return this.checkIfHeaderIsPresented(headers);
    }

    protected ValidationResult checkHeaderContent(Map<String, String> headers) {
        return ValidationResult.valid();
    }

    protected ValidationResult checkIfHeaderIsPresented(Map<String, String> headers) {
        if (!headers.containsKey(this.getHeaderName())) {
            return ValidationResult.invalid(this.errorBuildingService.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_ABSENT_HEADER, this.getHeaderName()));
        }
        String header = headers.get(this.getHeaderName());
        if (Objects.isNull(header)) {
            return ValidationResult.invalid(this.errorBuildingService.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_NULL_HEADER, this.getHeaderName()));
        }
        if (StringUtils.isBlank((CharSequence)header)) {
            return ValidationResult.invalid(this.errorBuildingService.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_BLANK_HEADER, this.getHeaderName()));
        }
        return this.checkHeaderContent(headers);
    }

    void checkBooleanFormat(Map<String, String> headers, MessageError messageError) {
        Boolean checker;
        String header = headers.get(this.getHeaderName());
        if (Objects.nonNull(header) && (checker = BooleanUtils.toBooleanObject((String)header)) == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_BOOLEAN_VALUE, this.getHeaderName()));
        }
    }
}

