/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.raw;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class FieldExtractor {
    private final ErrorBuildingService errorBuildingService;
    private final JsonConverter jsonConverter;

    public Optional<String> extractField(HttpServletRequest request, String fieldName, MessageError messageError) {
        Optional<String> fieldOptional = Optional.empty();
        try {
            fieldOptional = this.jsonConverter.toJsonField((InputStream)request.getInputStream(), fieldName, new TypeReference<String>(){});
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_DESERIALIZATION_FAIL));
        }
        return fieldOptional;
    }

    @ConstructorProperties(value={"errorBuildingService", "jsonConverter"})
    public FieldExtractor(ErrorBuildingService errorBuildingService, JsonConverter jsonConverter) {
        this.errorBuildingService = errorBuildingService;
        this.jsonConverter = jsonConverter;
    }
}

