/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.validator.certificate.util.CertificateExtractorUtil;
import de.adorsys.psd2.validator.certificate.util.TppCertificateData;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoHolder;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageBuilder;
import de.adorsys.psd2.xs2a.web.filter.AbstractXs2aFilter;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.difi.certvalidator.api.CertificateValidationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"!mock-qwac"})
@Component
public class QwacCertificateFilter
extends AbstractXs2aFilter {
    private static final Logger log = LoggerFactory.getLogger(QwacCertificateFilter.class);
    private final TppInfoHolder tppInfoHolder;
    private final RequestProviderService requestProviderService;
    private final TppErrorMessageBuilder tppErrorMessageBuilder;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String encodedTppQwacCert = this.getEncodedTppQwacCert(request);
        if (StringUtils.isNotBlank((CharSequence)encodedTppQwacCert)) {
            try {
                TppCertificateData tppCertificateData = CertificateExtractorUtil.extract((String)encodedTppQwacCert);
                if (this.isCertificateExpired(tppCertificateData.getNotAfter())) {
                    log.info("InR-ID: [{}], X-Request-ID: [{}], TPP Certificate is expired", (Object)this.requestProviderService.getInternalRequestId(), (Object)this.requestProviderService.getRequestId());
                    response.setStatus(401);
                    response.getWriter().print(this.tppErrorMessageBuilder.buildTppErrorMessage(MessageCategory.ERROR, MessageErrorCode.CERTIFICATE_EXPIRED));
                    return;
                }
                TppInfo tppInfo = new TppInfo();
                tppInfo.setAuthorisationNumber(tppCertificateData.getPspAuthorisationNumber());
                tppInfo.setTppName(tppCertificateData.getName());
                tppInfo.setAuthorityId(tppCertificateData.getPspAuthorityId());
                tppInfo.setAuthorityName(tppCertificateData.getPspAuthorityName());
                tppInfo.setCountry(tppCertificateData.getCountry());
                tppInfo.setOrganisation(tppCertificateData.getOrganisation());
                tppInfo.setOrganisationUnit(tppCertificateData.getOrganisationUnit());
                tppInfo.setCity(tppCertificateData.getCity());
                tppInfo.setState(tppCertificateData.getState());
                tppInfo.setIssuerCN(tppCertificateData.getIssuerCN());
                List tppRoles = tppCertificateData.getPspRoles();
                List xs2aTppRoles = tppRoles.stream().map(TppRole::valueOf).collect(Collectors.toList());
                tppInfo.setTppRoles(xs2aTppRoles);
                tppInfo.setDnsList(tppCertificateData.getDnsList());
                this.tppInfoHolder.setTppInfo(tppInfo);
            }
            catch (CertificateValidationException e) {
                log.info("InR-ID: [{}], X-Request-ID: [{}], TPP unauthorised because CertificateValidationException: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), e.getMessage()});
                response.setStatus(401);
                response.getWriter().print(this.tppErrorMessageBuilder.buildTppErrorMessage(MessageCategory.ERROR, MessageErrorCode.CERTIFICATE_INVALID_NO_ACCESS));
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public String getEncodedTppQwacCert(HttpServletRequest httpRequest) {
        return httpRequest.getHeader("tpp-qwac-certificate");
    }

    private boolean isCertificateExpired(Date date) {
        return Optional.ofNullable(date).map(d -> d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).map(d -> d.isBefore(LocalDateTime.now())).orElse(true);
    }

    @ConstructorProperties(value={"tppInfoHolder", "requestProviderService", "tppErrorMessageBuilder"})
    public QwacCertificateFilter(TppInfoHolder tppInfoHolder, RequestProviderService requestProviderService, TppErrorMessageBuilder tppErrorMessageBuilder) {
        this.tppInfoHolder = tppInfoHolder;
        this.requestProviderService = requestProviderService;
        this.tppErrorMessageBuilder = tppErrorMessageBuilder;
    }
}

