/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractLinkAspect<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractLinkAspect.class);
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    protected <B> boolean hasError(ResponseEntity<B> target) {
        Optional<Object> body = Optional.ofNullable(target.getBody());
        return body.isPresent() && body.get().getClass().isAssignableFrom(MessageError.class);
    }

    ScaRedirectFlow getScaRedirectFlow() {
        return this.aspspProfileServiceWrapper.getScaRedirectFlow();
    }

    String getHttpUrl() {
        return this.aspspProfileServiceWrapper.isForceXs2aBaseLinksUrl() ? this.aspspProfileServiceWrapper.getXs2aBaseLinksUrl() : ControllerLinkBuilder.linkTo(this.getControllerClass()).toString();
    }

    private Class<T> getControllerClass() {
        try {
            String className = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0].getTypeName();
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class isn't parametrized with generic type! Use <>");
        }
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper"})
    public AbstractLinkAspect(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

