/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.PisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.PisPsuDataUpdateAuthorisationCheckerValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.UpdatePisCancellationPsuDataPO;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdatePisCancellationPsuDataValidator
extends AbstractPisTppValidator<UpdatePisCancellationPsuDataPO> {
    private static final Logger log = LoggerFactory.getLogger(UpdatePisCancellationPsuDataValidator.class);
    private final PisEndpointAccessCheckerService pisEndpointAccessCheckerService;
    private final RequestProviderService requestProviderService;
    private final PisAuthorisationValidator pisAuthorisationValidator;
    private final PisAuthorisationStatusValidator pisAuthorisationStatusValidator;
    private final PisPsuDataUpdateAuthorisationCheckerValidator pisPsuDataUpdateAuthorisationCheckerValidator;

    @Override
    protected ValidationResult executeBusinessValidation(UpdatePisCancellationPsuDataPO paymentObject) {
        String authorisationId = paymentObject.getAuthorisationId();
        if (!this.pisEndpointAccessCheckerService.isEndpointAccessible(authorisationId, PaymentAuthorisationType.CANCELLED)) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Authorisation ID: [{}]. Updating PIS cancellation authorisation PSU Data has failed: endpoint is not accessible for authorisation", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), authorisationId});
            return ValidationResult.invalid(ErrorType.PIS_403, MessageErrorCode.SERVICE_BLOCKED);
        }
        ValidationResult authorisationValidationResult = this.pisAuthorisationValidator.validate(authorisationId, paymentObject.getPisCommonPaymentResponse());
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = paymentObject.getPisCommonPaymentResponse();
        Optional authorisationOptional = pisCommonPaymentResponse.findAuthorisationInPayment(authorisationId);
        if (!authorisationOptional.isPresent()) {
            return ValidationResult.invalid(ErrorType.PIS_403, MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        Authorisation authorisation = (Authorisation)authorisationOptional.get();
        ValidationResult validationResult = this.pisPsuDataUpdateAuthorisationCheckerValidator.validate(paymentObject.getPsuIdData(), authorisation.getPsuData());
        if (validationResult.isNotValid()) {
            return validationResult;
        }
        ValidationResult authorisationStatusValidationResult = this.pisAuthorisationStatusValidator.validate(authorisation.getScaStatus());
        if (authorisationStatusValidationResult.isNotValid()) {
            return authorisationStatusValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"pisEndpointAccessCheckerService", "requestProviderService", "pisAuthorisationValidator", "pisAuthorisationStatusValidator", "pisPsuDataUpdateAuthorisationCheckerValidator"})
    public UpdatePisCancellationPsuDataValidator(PisEndpointAccessCheckerService pisEndpointAccessCheckerService, RequestProviderService requestProviderService, PisAuthorisationValidator pisAuthorisationValidator, PisAuthorisationStatusValidator pisAuthorisationStatusValidator, PisPsuDataUpdateAuthorisationCheckerValidator pisPsuDataUpdateAuthorisationCheckerValidator) {
        this.pisEndpointAccessCheckerService = pisEndpointAccessCheckerService;
        this.requestProviderService = requestProviderService;
        this.pisAuthorisationValidator = pisAuthorisationValidator;
        this.pisAuthorisationStatusValidator = pisAuthorisationStatusValidator;
        this.pisPsuDataUpdateAuthorisationCheckerValidator = pisPsuDataUpdateAuthorisationCheckerValidator;
    }
}

