/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.profile;

import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.core.profile.StartAuthorisationMode;
import de.adorsys.psd2.xs2a.domain.account.SupportedAccountReferenceField;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileServiceWrapper {
    private final AspspProfileService aspspProfileService;

    public Map<PaymentType, Set<String>> getSupportedPaymentTypeAndProductMatrix() {
        return this.readAspspSettings().getPis().getSupportedPaymentTypeAndProductMatrix();
    }

    public List<ScaApproach> getScaApproaches() {
        return this.aspspProfileService.getScaApproaches();
    }

    public Boolean getTppSignatureRequired() {
        return this.readAspspSettings().getCommon().isTppSignatureRequired();
    }

    public String getPisRedirectUrlToAspsp() {
        return this.readAspspSettings().getPis().getRedirectLinkToOnlineBanking().getPisRedirectUrlToAspsp();
    }

    public String getAisRedirectUrlToAspsp() {
        return this.readAspspSettings().getAis().getRedirectLinkToOnlineBanking().getAisRedirectUrlToAspsp();
    }

    public List<SupportedAccountReferenceField> getSupportedAccountReferenceFields() {
        List supportedAccountReferenceFields = this.readAspspSettings().getCommon().getSupportedAccountReferenceFields();
        return supportedAccountReferenceFields.stream().map(reference -> SupportedAccountReferenceField.valueOf(reference.name())).collect(Collectors.toList());
    }

    public int getMaxConsentValidityDays() {
        return this.readAspspSettings().getAis().getConsentTypes().getMaxConsentValidityDays();
    }

    public Boolean isGlobalConsentSupported() {
        return this.readAspspSettings().getAis().getConsentTypes().isGlobalConsentSupported();
    }

    public boolean isBankOfferedConsentSupported() {
        return this.readAspspSettings().getAis().getConsentTypes().isBankOfferedConsentSupported();
    }

    public boolean isTransactionsWithoutBalancesSupported() {
        return this.readAspspSettings().getAis().getTransactionParameters().isTransactionsWithoutBalancesSupported();
    }

    public boolean isSigningBasketSupported() {
        return this.readAspspSettings().getCommon().isSigningBasketSupported();
    }

    public boolean isPaymentCancellationAuthorisationMandated() {
        return this.readAspspSettings().getPis().isPaymentCancellationAuthorisationMandated();
    }

    public boolean isPiisConsentSupported() {
        return this.readAspspSettings().getPiis().isPiisConsentSupported();
    }

    public long getRedirectUrlExpirationTimeMs() {
        return this.readAspspSettings().getCommon().getRedirectUrlExpirationTimeMs();
    }

    public long getAuthorisationExpirationTimeMs() {
        return this.readAspspSettings().getCommon().getAuthorisationExpirationTimeMs();
    }

    public String getPisPaymentCancellationRedirectUrlToAspsp() {
        return this.readAspspSettings().getPis().getRedirectLinkToOnlineBanking().getPisPaymentCancellationRedirectUrlToAspsp();
    }

    public boolean isAvailableAccountsConsentSupported() {
        return this.readAspspSettings().getAis().getConsentTypes().isAvailableAccountsConsentSupported();
    }

    public boolean isScaByOneTimeAvailableAccountsConsentRequired() {
        return this.readAspspSettings().getAis().getScaRequirementsForOneTimeConsents().isScaByOneTimeAvailableAccountsConsentRequired();
    }

    public boolean isScaByOneTimeGlobalConsentRequired() {
        return this.readAspspSettings().getAis().getScaRequirementsForOneTimeConsents().isScaByOneTimeGlobalConsentRequired();
    }

    public boolean isPsuInInitialRequestMandated() {
        return this.readAspspSettings().getCommon().isPsuInInitialRequestMandated();
    }

    public boolean isForceXs2aBaseLinksUrl() {
        return this.readAspspSettings().getCommon().isForceXs2aBaseLinksUrl();
    }

    public String getXs2aBaseLinksUrl() {
        return this.readAspspSettings().getCommon().getXs2aBaseLinksUrl();
    }

    public boolean isAisPisSessionsSupported() {
        return this.readAspspSettings().getCommon().isAisPisSessionsSupported();
    }

    public boolean isDeltaListSupported() {
        return this.readAspspSettings().getAis().getDeltaReportSettings().isDeltaListSupported();
    }

    public boolean isEntryReferenceFromSupported() {
        return this.readAspspSettings().getAis().getDeltaReportSettings().isEntryReferenceFromSupported();
    }

    public List<BookingStatus> getAvailableBookingStatuses() {
        return this.readAspspSettings().getAis().getTransactionParameters().getAvailableBookingStatuses();
    }

    public StartAuthorisationMode getStartAuthorisationMode() {
        return this.readAspspSettings().getCommon().getStartAuthorisationMode();
    }

    public ScaRedirectFlow getScaRedirectFlow() {
        return this.readAspspSettings().getCommon().getScaRedirectFlow();
    }

    public int getAccountAccessFrequencyPerDay() {
        return this.readAspspSettings().getAis().getConsentTypes().getAccountAccessFrequencyPerDay();
    }

    public List<String> getSupportedTransactionApplicationTypes() {
        return this.readAspspSettings().getAis().getTransactionParameters().getSupportedTransactionApplicationTypes();
    }

    private AspspSettings readAspspSettings() {
        return this.aspspProfileService.getAspspSettings();
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AspspProfileServiceWrapper(AspspProfileService aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

