/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.piis;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.exception.model.error429.Error429NGPIIS;
import de.adorsys.psd2.xs2a.exception.model.error429.TppMessage429PIIS;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIIS429ErrorMapper
extends Psd2ErrorMapper<MessageError, Error429NGPIIS> {
    @Override
    public Function<MessageError, Error429NGPIIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.TOO_MANY_REQUESTS;
    }

    private Error429NGPIIS mapToPsd2Error(MessageError messageError) {
        return new Error429NGPIIS().tppMessages(this.mapToTppMessage429PIIS(messageError.getTppMessages()));
    }

    private List<TppMessage429PIIS> mapToTppMessage429PIIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage429PIIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(m.getMessageErrorCode().getName()).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

