/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais.stage.embedded;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.CommonDecoupledAisService;
import de.adorsys.psd2.xs2a.service.authorization.ais.stage.AisScaStage;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAuthenticationObjectMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAvailableScaMethodsResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AIS_RECEIVED")
public class AisScaReceivedAuthorisationStage
extends AisScaStage<UpdateConsentPsuDataReq, UpdateConsentPsuDataResponse> {
    private static final Logger log = LoggerFactory.getLogger(AisScaReceivedAuthorisationStage.class);
    private final SpiContextDataProvider spiContextDataProvider;
    private final CommonDecoupledAisService commonDecoupledAisService;
    private final AisScaAuthorisationService aisScaAuthorisationService;
    private final RequestProviderService requestProviderService;

    public AisScaReceivedAuthorisationStage(Xs2aAisConsentService aisConsentService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AisConsentSpi aisConsentSpi, Xs2aAisConsentMapper aisConsentMapper, Xs2aToSpiPsuDataMapper psuDataMapper, SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, CommonDecoupledAisService commonDecoupledAisService, AisScaAuthorisationService aisScaAuthorisationService, RequestProviderService requestProviderService) {
        super(aisConsentService, aspspConsentDataProviderFactory, aisConsentSpi, aisConsentMapper, psuDataMapper, spiToXs2aAuthenticationObjectMapper, spiErrorMapper);
        this.spiContextDataProvider = spiContextDataProvider;
        this.commonDecoupledAisService = commonDecoupledAisService;
        this.aisScaAuthorisationService = aisScaAuthorisationService;
        this.requestProviderService = requestProviderService;
    }

    @Override
    public UpdateConsentPsuDataResponse apply(UpdateConsentPsuDataReq request) {
        return request.isUpdatePsuIdentification() ? this.applyIdentification(request) : this.applyAuthorisation(request);
    }

    private UpdateConsentPsuDataResponse applyAuthorisation(UpdateConsentPsuDataReq request) {
        String consentId = request.getConsentId();
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}]. AIS_RECEIVED stage. Apply authorisation when update consent PSU data has failed. Consent not found by id.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            MessageError messageError = new MessageError(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400));
            return this.createFailedResponse(messageError, Collections.emptyList(), request);
        }
        String authorisationId = request.getAuthorizationId();
        PsuIdData psuData = this.extractPsuIdData(request);
        String psuId = psuData.getPsuId();
        AccountConsent accountConsent = accountConsentOptional.get();
        SpiAccountConsent spiAccountConsent = this.aisConsentMapper.mapToSpiAccountConsent(accountConsent);
        SpiResponse authorisationStatusSpiResponse = this.aisConsentSpi.authorisePsu(this.spiContextDataProvider.provideWithPsuIdData(psuData), this.psuDataMapper.mapToSpiPsuData(psuData), request.getPassword(), (Object)spiAccountConsent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (authorisationStatusSpiResponse.hasError()) {
            MessageError messageError = new MessageError(this.spiErrorMapper.mapToErrorHolder(authorisationStatusSpiResponse, ServiceType.AIS));
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}]. AIS_RECEIVED stage. Authorise PSU when apply authorisation has failed. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, authorisationId, psuId, messageError});
            return this.createFailedResponse(messageError, authorisationStatusSpiResponse.getErrors(), request);
        }
        if (((SpiPsuAuthorisationResponse)authorisationStatusSpiResponse.getPayload()).getSpiAuthorisationStatus() == SpiAuthorisationStatus.FAILURE) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}]. AIS_RECEIVED stage. Authorise PSU when apply authorisation has failed. PSU credentials invalid.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, authorisationId, psuId});
            MessageError messageError = new MessageError(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.PSU_CREDENTIALS_INVALID));
            UpdateConsentPsuDataResponse failedResponse = this.createFailedResponse(messageError, Collections.singletonList(new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, new Object[0])), request);
            this.aisConsentService.updateConsentAuthorization(this.aisConsentMapper.mapToSpiUpdateConsentPsuDataReq(failedResponse, request));
            return failedResponse;
        }
        if (this.aisScaAuthorisationService.isOneFactorAuthorisation(accountConsent)) {
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.VALID);
            UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, consentId, authorisationId);
            response.setScaAuthenticationData(request.getScaAuthenticationData());
            return response;
        }
        SpiResponse spiResponse = this.aisConsentSpi.requestAvailableScaMethods(this.spiContextDataProvider.provideWithPsuIdData(psuData), (Object)spiAccountConsent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            MessageError messageError = new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS));
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}]. AIS_RECEIVED stage. Request available SCA methods when apply authorisation has failed. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, authorisationId, psuId, messageError});
            return this.createFailedResponse(messageError, spiResponse.getErrors(), request);
        }
        List availableScaMethods = ((SpiAvailableScaMethodsResponse)spiResponse.getPayload()).getAvailableScaMethods();
        if (CollectionUtils.isNotEmpty((Collection)availableScaMethods)) {
            this.aisConsentService.saveAuthenticationMethods(authorisationId, this.spiToXs2aAuthenticationObjectMapper.mapToXs2aListAuthenticationObject(availableScaMethods));
            if (availableScaMethods.size() > 1) {
                return this.createResponseForMultipleAvailableMethods(availableScaMethods, authorisationId, consentId);
            }
            return this.createResponseForOneAvailableMethod(request, spiAccountConsent, (SpiAuthenticationObject)availableScaMethods.get(0), psuData);
        }
        log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}]. AIS_RECEIVED stage. Apply authorisation has failed. Consent rejected because no available SCA methods.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, authorisationId, psuId});
        this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.REJECTED);
        UpdateConsentPsuDataResponse response = this.createResponseForNoneAvailableScaMethod(consentId, authorisationId);
        this.aisConsentService.updateConsentAuthorization(this.aisConsentMapper.mapToSpiUpdateConsentPsuDataReq(response, request));
        return response;
    }

    private UpdateConsentPsuDataResponse applyIdentification(UpdateConsentPsuDataReq request) {
        if (!this.isPsuExist(request.getPsuData())) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authorisation-ID [{}]. AIS_RECEIVED stage. Apply identification when update consent PSU data has failed. No PSU data available in request.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getConsentId(), request.getAuthorizationId()});
            MessageError messageError = new MessageError(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_NO_PSU));
            return this.createFailedResponse(messageError, Collections.singletonList(new TppMessage(MessageErrorCode.FORMAT_ERROR_NO_PSU, new Object[0])), request);
        }
        return new UpdateConsentPsuDataResponse(ScaStatus.PSUIDENTIFIED, request.getConsentId(), request.getAuthorizationId());
    }

    private UpdateConsentPsuDataResponse createResponseForMultipleAvailableMethods(List<SpiAuthenticationObject> availableScaMethods, String authorisationId, String consentId) {
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.PSUAUTHENTICATED, consentId, authorisationId);
        response.setAvailableScaMethods(this.spiToXs2aAuthenticationObjectMapper.mapToXs2aListAuthenticationObject(availableScaMethods));
        return response;
    }

    private UpdateConsentPsuDataResponse createResponseForOneAvailableMethod(UpdateConsentPsuDataReq request, SpiAccountConsent spiAccountConsent, SpiAuthenticationObject scaMethod, PsuIdData psuData) {
        if (scaMethod.isDecoupled()) {
            this.aisConsentService.updateScaApproach(request.getAuthorizationId(), ScaApproach.DECOUPLED);
            return this.commonDecoupledAisService.proceedDecoupledApproach(request, spiAccountConsent, scaMethod.getAuthenticationMethodId(), psuData);
        }
        return this.proceedEmbeddedScaApproach(request, spiAccountConsent, scaMethod);
    }

    private UpdateConsentPsuDataResponse proceedEmbeddedScaApproach(UpdateConsentPsuDataReq request, SpiAccountConsent spiAccountConsent, SpiAuthenticationObject scaMethod) {
        PsuIdData psuData = request.getPsuData();
        String authenticationMethodId = scaMethod.getAuthenticationMethodId();
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(request.getConsentId());
        SpiResponse spiResponse = this.aisConsentSpi.requestAuthorisationCode(this.spiContextDataProvider.provideWithPsuIdData(psuData), authenticationMethodId, (Object)spiAccountConsent, aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            MessageError messageError = new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS));
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}], Authentication-Method-ID [{}]. AIS_RECEIVED stage. Proceed embedded approach when performs authorisation depending on selected SCA method has failed. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getConsentId(), request.getAuthorizationId(), request.getPsuData().getPsuId(), authenticationMethodId, messageError});
            return this.createFailedResponse(messageError, spiResponse.getErrors(), request);
        }
        SpiAuthorizationCodeResult authorizationCodeResult = (SpiAuthorizationCodeResult)spiResponse.getPayload();
        ChallengeData challengeData = authorizationCodeResult.getChallengeData();
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.SCAMETHODSELECTED, request.getConsentId(), request.getAuthorizationId());
        response.setChosenScaMethod(this.spiToXs2aAuthenticationObjectMapper.mapToXs2aAuthenticationObject(scaMethod));
        response.setChallengeData(challengeData);
        return response;
    }

    private UpdateConsentPsuDataResponse createResponseForNoneAvailableScaMethod(String consentId, String authorisationId) {
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.FAILED, consentId, authorisationId);
        response.setMessageError(new MessageError(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.SCA_METHOD_UNKNOWN)));
        return response;
    }
}

