/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.consent.ErrorToActionStatusMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAccountReferenceMapper;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountHelperService {
    private static final Logger log = LoggerFactory.getLogger(AccountHelperService.class);
    private final Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper;
    private final ErrorToActionStatusMapper errorToActionStatusMapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final RequestProviderService requestProviderService;

    public SpiAccountReference findAccountReference(AccountAccessType allPsd2, List<AccountReference> references, String resourceId) {
        if (allPsd2 != null) {
            return new SpiAccountReference(resourceId, null, null, null, null, null, null);
        }
        return references.stream().filter(accountReference -> StringUtils.equals((CharSequence)accountReference.getResourceId(), (CharSequence)resourceId)).findFirst().map(this.xs2aToSpiAccountReferenceMapper::mapToSpiAccountReference).orElse(null);
    }

    public SpiContextData getSpiContextData() {
        PsuIdData psuIdData = this.requestProviderService.getPsuIdData();
        log.info("X-Request-ID: [{}]. Corresponding PSU-ID {} was provided from request.", (Object)this.requestProviderService.getRequestId(), (Object)psuIdData);
        return this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
    }

    ActionStatus createActionStatus(boolean withBalance, TypeAccess access, ResponseObject response) {
        return response.hasError() ? this.errorToActionStatusMapper.mapActionStatusError(response.getError().getTppMessage().getMessageErrorCode(), withBalance, access) : ActionStatus.SUCCESS;
    }

    boolean needsToUpdateUsage(AccountConsent accountConsent) {
        return accountConsent.isOneAccessType() || this.requestProviderService.isRequestFromTPP();
    }

    @ConstructorProperties(value={"xs2aToSpiAccountReferenceMapper", "errorToActionStatusMapper", "spiContextDataProvider", "requestProviderService"})
    public AccountHelperService(Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper, ErrorToActionStatusMapper errorToActionStatusMapper, SpiContextDataProvider spiContextDataProvider, RequestProviderService requestProviderService) {
        this.xs2aToSpiAccountReferenceMapper = xs2aToSpiAccountReferenceMapper;
        this.errorToActionStatusMapper = errorToActionStatusMapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.requestProviderService = requestProviderService;
    }
}

