/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ErrorHolder {
    private final List<TppMessageInformation> tppMessageInformationList;
    private final ErrorType errorType;

    private ErrorHolder(ErrorHolderBuilder builder) {
        this.tppMessageInformationList = builder.tppMessageInformationList;
        this.errorType = builder.errorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public List<TppMessageInformation> getTppMessageInformationList() {
        return this.tppMessageInformationList;
    }

    public static ErrorHolderBuilder builder(ErrorType errorType) {
        return new ErrorHolderBuilder(errorType);
    }

    public String toString() {
        return CollectionUtils.isEmpty(this.tppMessageInformationList) ? Optional.ofNullable(this.errorType).map(Enum::name).orElse("") : this.tppMessageInformationList.stream().map(t -> t.getMessageErrorCode().getName()).collect(Collectors.joining(", "));
    }

    public static class ErrorHolderBuilder {
        private List<TppMessageInformation> tppMessageInformationList = new ArrayList<TppMessageInformation>();
        private ErrorType errorType;

        private ErrorHolderBuilder(ErrorType errorType) {
            this.errorType = errorType;
        }

        public ErrorHolderBuilder tppMessages(TppMessageInformation ... tppMessages) {
            this.tppMessageInformationList = Arrays.asList(tppMessages);
            return this;
        }

        public ErrorHolder build() {
            return new ErrorHolder(this);
        }
    }
}

