/*
 * Copyright 2018-2019 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.domain.InternalRequestIdHolder;
import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

import java.util.UUID;

@Service
@RequiredArgsConstructor
public class InternalRequestIdService {
    private final InternalRequestIdHolder internalRequestIdHolder;

    /**
     * Returns unique internal request ID that was assigned to the current request
     *
     * @return internal request ID
     */
    @NotNull
    public UUID getInternalRequestId() {
        UUID idFromHolder = internalRequestIdHolder.getInternalRequestId();

        if (idFromHolder == null) {
            return generateInternalRequestId();
        }

        return idFromHolder;
    }

    @NotNull
    private UUID generateInternalRequestId() {
        UUID internalRequestId = UUID.randomUUID();
        internalRequestIdHolder.setInternalRequestId(internalRequestId);
        return internalRequestId;
    }
}
