/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.raw;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class FieldExtractor {
    private final ErrorBuildingService errorBuildingService;
    private final Xs2aObjectMapper xs2aObjectMapper;

    public Optional<String> extractField(HttpServletRequest request, String fieldName, MessageError messageError) {
        Optional fieldOptional = Optional.empty();
        try {
            fieldOptional = this.xs2aObjectMapper.toJsonField((InputStream)request.getInputStream(), fieldName, (TypeReference)new TypeReference<String>(){});
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_DESERIALIZATION_FAIL));
        }
        return fieldOptional;
    }

    @ConstructorProperties(value={"errorBuildingService", "xs2aObjectMapper"})
    public FieldExtractor(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper) {
        this.errorBuildingService = errorBuildingService;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

