/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.type;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AmountValidator;
import de.adorsys.psd2.xs2a.web.validator.body.IbanValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.config.PaymentValidationConfig;
import de.adorsys.psd2.xs2a.web.validator.body.payment.mapper.PaymentMapper;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.SinglePaymentTypeValidatorImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BulkPaymentTypeValidatorImpl
extends SinglePaymentTypeValidatorImpl {
    @Autowired
    public BulkPaymentTypeValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, PaymentMapper paymentMapper, AmountValidator amountValidator, PaymentValidationConfig validationConfig, IbanValidator ibanValidator) {
        super(errorBuildingService, xs2aObjectMapper, paymentMapper, amountValidator, validationConfig, ibanValidator);
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.BULK;
    }

    @Override
    public MessageError validate(Object body, MessageError messageError) {
        try {
            this.doBulkValidation(this.paymentMapper.getBulkPayment(body), messageError);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("Unrecognized field")) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_EXTRA_FIELD, this.extractErrorField(e.getMessage())));
            }
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR));
        }
        return messageError;
    }

    void doBulkValidation(BulkPayment bulkPayment, MessageError messageError) {
        if (bulkPayment.getDebtorAccount() != null) {
            this.validateAccount(bulkPayment.getDebtorAccount(), messageError);
        }
        List<SinglePayment> payments = bulkPayment.getPayments();
        payments.forEach(singlePayment -> super.doSingleValidation((SinglePayment)singlePayment, messageError));
        if (this.isDateInThePast(bulkPayment.getRequestedExecutionDate())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.EXECUTION_DATE_INVALID_IN_THE_PAST));
        }
    }
}

