/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AmountValidator {
    private static final String CORRECT_AMOUNT_REGEX = "-?[0-9]{1,14}([.]{1}[0-9]{1,3})?";
    private static final String AMOUNT_STRING = "amount";
    private final ErrorBuildingService errorBuildingService;

    public void validateAmount(String amount, MessageError messageError) {
        if (amount == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_NULL_VALUE, AMOUNT_STRING));
        } else if (StringUtils.isBlank((CharSequence)amount)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_EMPTY_FIELD, AMOUNT_STRING));
        } else if (!Pattern.matches(CORRECT_AMOUNT_REGEX, amount)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, AMOUNT_STRING));
        }
    }

    @ConstructorProperties(value={"errorBuildingService"})
    public AmountValidator(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }
}

