/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.model.BulkPaymentInitiationWithStatusResponse;
import de.adorsys.psd2.model.ChosenScaMethod;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.MessageCode2XX;
import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.model.PaymentInitiationBulkElementJson;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse202;
import de.adorsys.psd2.model.PaymentInitiationStatusResponse200Json;
import de.adorsys.psd2.model.PaymentInitiationWithStatusResponse;
import de.adorsys.psd2.model.PeriodicPaymentInitiationWithStatusResponse;
import de.adorsys.psd2.model.TppMessage2XX;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aChosenScaMethod;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.GetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.AccountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import de.adorsys.psd2.xs2a.web.mapper.TppRedirectUriMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapperPsd2 {
    private static final Logger log = LoggerFactory.getLogger(PaymentModelMapperPsd2.class);
    private final CoreObjectsMapper coreObjectsMapper;
    private final AccountModelMapper accountModelMapper;
    private final TppRedirectUriMapper tppRedirectUriMapper;
    private final AmountModelMapper amountModelMapper;
    private final HrefLinkMapper hrefLinkMapper;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final ScaMethodsMapper scaMethodsMapper;
    private final Xs2aAddressMapper xs2aAddressMapper;
    private final RemittanceMapper remittanceMapper;
    private final PurposeCodeMapper purposeCodeMapper;

    public Object mapToGetPaymentResponse(Object payment, PaymentType type, String paymentProduct) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(paymentProduct)) {
            return this.convertResponseToRawData(((CommonPayment)payment).getPaymentData());
        }
        if (type == PaymentType.SINGLE) {
            SinglePayment xs2aPayment = (SinglePayment)payment;
            PaymentInitiationWithStatusResponse paymentResponse = new PaymentInitiationWithStatusResponse();
            paymentResponse.setEndToEndIdentification(xs2aPayment.getEndToEndIdentification());
            paymentResponse.setInstructionIdentification(xs2aPayment.getInstructionIdentification());
            paymentResponse.setDebtorAccount(this.accountModelMapper.mapToAccountReference(xs2aPayment.getDebtorAccount()));
            paymentResponse.setInstructedAmount(this.amountModelMapper.mapToAmount(xs2aPayment.getInstructedAmount()));
            paymentResponse.setCreditorAccount(this.accountModelMapper.mapToAccountReference(xs2aPayment.getCreditorAccount()));
            paymentResponse.setCreditorAgent(xs2aPayment.getCreditorAgent());
            paymentResponse.setCreditorName(xs2aPayment.getCreditorName());
            paymentResponse.setCreditorAddress(this.xs2aAddressMapper.mapToAddress(xs2aPayment.getCreditorAddress()));
            paymentResponse.setRemittanceInformationUnstructured(xs2aPayment.getRemittanceInformationUnstructured());
            paymentResponse.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus(xs2aPayment.getTransactionStatus()));
            paymentResponse.setUltimateDebtor(xs2aPayment.getUltimateDebtor());
            paymentResponse.setUltimateCreditor(xs2aPayment.getUltimateCreditor());
            paymentResponse.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(xs2aPayment.getPurposeCode()));
            paymentResponse.setRemittanceInformationStructured(this.remittanceMapper.mapToRemittanceInformationStructured(xs2aPayment.getRemittanceInformationStructured()));
            paymentResponse.setRequestedExecutionDate(xs2aPayment.getRequestedExecutionDate());
            return paymentResponse;
        }
        if (type == PaymentType.PERIODIC) {
            PeriodicPayment xs2aPayment = (PeriodicPayment)payment;
            PeriodicPaymentInitiationWithStatusResponse paymentResponse = new PeriodicPaymentInitiationWithStatusResponse();
            paymentResponse.setEndToEndIdentification(xs2aPayment.getEndToEndIdentification());
            paymentResponse.setInstructionIdentification(xs2aPayment.getInstructionIdentification());
            paymentResponse.setDebtorAccount(this.accountModelMapper.mapToAccountReference(xs2aPayment.getDebtorAccount()));
            paymentResponse.setInstructedAmount(this.amountModelMapper.mapToAmount(xs2aPayment.getInstructedAmount()));
            paymentResponse.setCreditorAccount(this.accountModelMapper.mapToAccountReference(xs2aPayment.getCreditorAccount()));
            paymentResponse.setCreditorAgent(xs2aPayment.getCreditorAgent());
            paymentResponse.setCreditorName(xs2aPayment.getCreditorName());
            paymentResponse.setCreditorAddress(this.xs2aAddressMapper.mapToAddress(xs2aPayment.getCreditorAddress()));
            paymentResponse.setRemittanceInformationUnstructured(xs2aPayment.getRemittanceInformationUnstructured());
            paymentResponse.setStartDate(xs2aPayment.getStartDate());
            paymentResponse.setEndDate(xs2aPayment.getEndDate());
            paymentResponse.setExecutionRule((ExecutionRule)this.mapToExecutionRule(xs2aPayment.getExecutionRule()).orElse(null));
            paymentResponse.setFrequency(FrequencyCode.valueOf((String)xs2aPayment.getFrequency().name()));
            paymentResponse.setDayOfExecution((DayOfExecution)this.mapToDayOfExecution(xs2aPayment.getDayOfExecution()).orElse(null));
            paymentResponse.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus(xs2aPayment.getTransactionStatus()));
            paymentResponse.setUltimateDebtor(xs2aPayment.getUltimateDebtor());
            paymentResponse.setUltimateCreditor(xs2aPayment.getUltimateCreditor());
            paymentResponse.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(xs2aPayment.getPurposeCode()));
            paymentResponse.setRemittanceInformationStructured(this.remittanceMapper.mapToRemittanceInformationStructured(xs2aPayment.getRemittanceInformationStructured()));
            return paymentResponse;
        }
        BulkPayment xs2aPayment = (BulkPayment)payment;
        BulkPaymentInitiationWithStatusResponse paymentResponse = new BulkPaymentInitiationWithStatusResponse();
        paymentResponse.setBatchBookingPreferred(xs2aPayment.getBatchBookingPreferred());
        paymentResponse.setRequestedExecutionDate(xs2aPayment.getRequestedExecutionDate());
        paymentResponse.setDebtorAccount(this.accountModelMapper.mapToAccountReference(xs2aPayment.getDebtorAccount()));
        paymentResponse.setPayments(this.mapToBulkPartList(xs2aPayment.getPayments()));
        paymentResponse.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus(xs2aPayment.getTransactionStatus()));
        return paymentResponse;
    }

    public static PaymentInitiationStatusResponse200Json mapToStatusResponse(GetPaymentStatusResponse response) {
        return new PaymentInitiationStatusResponse200Json().transactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus(response.getTransactionStatus())).fundsAvailable(response.getFundsAvailable());
    }

    public static de.adorsys.psd2.model.TransactionStatus mapToTransactionStatus(TransactionStatus responseObject) {
        return Optional.ofNullable(responseObject).map(r -> de.adorsys.psd2.model.TransactionStatus.valueOf((String)r.name())).orElse(null);
    }

    public PaymentInitationRequestResponse201 mapToPaymentInitiationResponse(PaymentInitiationResponse response) {
        PaymentInitationRequestResponse201 response201 = new PaymentInitationRequestResponse201();
        response201.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus(response.getTransactionStatus()));
        response201.setPaymentId(response.getPaymentId());
        response201.setTransactionFees(this.amountModelMapper.mapToAmount(response.getTransactionFees()));
        response201.setTransactionFeeIndicator(response.getTransactionFeeIndicator());
        response201.setScaMethods(this.scaMethodsMapper.mapToScaMethods(response.getScaMethods()));
        response201.setChallengeData(this.coreObjectsMapper.mapToChallengeData(response.getChallengeData()));
        response201.setLinks(this.hrefLinkMapper.mapToLinksMap(response.getLinks()));
        response201.setPsuMessage(response.getPsuMessage());
        response201.setTppMessages(this.mapToTppMessage2XXList(response.getTppMessageInformation()));
        return response201;
    }

    public PaymentInitiationParameters mapToPaymentRequestParameters(String paymentProduct, String paymentService, byte[] tpPSignatureCertificate, String tpPRedirectURI, String tpPNokRedirectURI, boolean tppExplicitAuthorisationPreferred, PsuIdData psuData) {
        PaymentInitiationParameters parameters = new PaymentInitiationParameters();
        parameters.setPaymentType((PaymentType)PaymentType.getByValue((String)paymentService).orElseThrow(() -> new IllegalArgumentException("Unsupported payment service")));
        parameters.setPaymentProduct(Optional.ofNullable(paymentProduct).orElseThrow(() -> new IllegalArgumentException("Unsupported payment product")));
        parameters.setQwacCertificate(new String(Optional.ofNullable(tpPSignatureCertificate).orElse(new byte[0]), StandardCharsets.UTF_8));
        parameters.setTppRedirectUri(this.tppRedirectUriMapper.mapToTppRedirectUri(tpPRedirectURI, tpPNokRedirectURI));
        parameters.setTppExplicitAuthorisationPreferred(tppExplicitAuthorisationPreferred);
        parameters.setPsuData(psuData);
        return parameters;
    }

    public PisPaymentCancellationRequest mapToPaymentCancellationRequest(String paymentProduct, String paymentService, String paymentId, Boolean tppExplicitAuthorisationPreferred, String tpPRedirectURI, String tpPNokRedirectURI) {
        return new PisPaymentCancellationRequest((PaymentType)PaymentType.getByValue((String)paymentService).orElseThrow(() -> new IllegalArgumentException("Unsupported payment service")), Optional.ofNullable(paymentProduct).orElseThrow(() -> new IllegalArgumentException("Unsupported payment product")), paymentId, Boolean.valueOf(BooleanUtils.isTrue((Boolean)tppExplicitAuthorisationPreferred)), this.tppRedirectUriMapper.mapToTppRedirectUri(tpPRedirectURI, tpPNokRedirectURI));
    }

    public PaymentInitiationCancelResponse202 mapToPaymentInitiationCancelResponse(CancelPaymentResponse cancelPaymentResponse) {
        PaymentInitiationCancelResponse202 response = new PaymentInitiationCancelResponse202();
        response.setTransactionStatus(PaymentModelMapperPsd2.mapToTransactionStatus(cancelPaymentResponse.getTransactionStatus()));
        response.setScaMethods(this.scaMethodsMapper.mapToScaMethods(cancelPaymentResponse.getScaMethods()));
        response.setChosenScaMethod(this.mapToChosenScaMethod(cancelPaymentResponse.getChosenScaMethod()));
        response.setChallengeData(this.coreObjectsMapper.mapToChallengeData(cancelPaymentResponse.getChallengeData()));
        response._links(this.hrefLinkMapper.mapToLinksMap(cancelPaymentResponse.getLinks()));
        response.setTppMessages(this.mapToTppMessage2XXList(cancelPaymentResponse.getTppMessageInformation()));
        return response;
    }

    private List<PaymentInitiationBulkElementJson> mapToBulkPartList(List<SinglePayment> payments) {
        return payments.stream().map(this::mapToBulkPart).collect(Collectors.toList());
    }

    private PaymentInitiationBulkElementJson mapToBulkPart(SinglePayment payment) {
        PaymentInitiationBulkElementJson bulkPart = new PaymentInitiationBulkElementJson().endToEndIdentification(payment.getEndToEndIdentification());
        bulkPart.setInstructionIdentification(payment.getInstructionIdentification());
        bulkPart.setInstructedAmount(this.amountModelMapper.mapToAmount(payment.getInstructedAmount()));
        bulkPart.setCreditorAccount(this.accountModelMapper.mapToAccountReference(payment.getCreditorAccount()));
        bulkPart.setCreditorAgent(payment.getCreditorAgent());
        bulkPart.setCreditorName(payment.getCreditorName());
        bulkPart.setCreditorAddress(this.xs2aAddressMapper.mapToAddress(payment.getCreditorAddress()));
        bulkPart.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        bulkPart.setUltimateDebtor(payment.getUltimateDebtor());
        bulkPart.setUltimateCreditor(payment.getUltimateCreditor());
        bulkPart.setPurposeCode(this.purposeCodeMapper.mapToPurposeCode(payment.getPurposeCode()));
        bulkPart.setRemittanceInformationStructured(this.remittanceMapper.mapToRemittanceInformationStructured(payment.getRemittanceInformationStructured()));
        return bulkPart;
    }

    private ChosenScaMethod mapToChosenScaMethod(Xs2aChosenScaMethod xs2aChosenScaMethod) {
        return Optional.ofNullable(xs2aChosenScaMethod).map(ch -> {
            ChosenScaMethod method = new ChosenScaMethod();
            method.setAuthenticationMethodId(ch.getAuthenticationMethodId());
            method.setAuthenticationType(ch.getAuthenticationType());
            return method;
        }).orElse(null);
    }

    private String convertResponseToRawData(byte[] paymentData) {
        try {
            return IOUtils.toString((byte[])paymentData, (String)Charset.defaultCharset().name());
        }
        catch (IOException e) {
            log.warn("Can not convert payment from byte[] ", (Throwable)e);
            return null;
        }
    }

    private Optional<DayOfExecution> mapToDayOfExecution(PisDayOfExecution dayOfExecution) {
        return Optional.ofNullable(dayOfExecution).map(PisDayOfExecution::toString).map(DayOfExecution::fromValue);
    }

    private Optional<ExecutionRule> mapToExecutionRule(PisExecutionRule rule) {
        return Optional.ofNullable(rule).map(PisExecutionRule::toString).map(ExecutionRule::fromValue);
    }

    private List<TppMessage2XX> mapToTppMessage2XXList(Set<TppMessageInformation> tppMessages) {
        if (CollectionUtils.isEmpty(tppMessages)) {
            return null;
        }
        return tppMessages.stream().map(this::mapToTppMessage2XX).collect(Collectors.toList());
    }

    private TppMessage2XX mapToTppMessage2XX(TppMessageInformation tppMessage) {
        TppMessage2XX tppMessage2XX = new TppMessage2XX();
        tppMessage2XX.setCategory(TppMessageCategory.fromValue((String)tppMessage.getCategory().name()));
        tppMessage2XX.setCode(MessageCode2XX.WARNING);
        tppMessage2XX.setPath(tppMessage.getPath());
        tppMessage2XX.setText(tppMessage.getText());
        return tppMessage2XX;
    }

    @ConstructorProperties(value={"coreObjectsMapper", "accountModelMapper", "tppRedirectUriMapper", "amountModelMapper", "hrefLinkMapper", "standardPaymentProductsResolver", "scaMethodsMapper", "xs2aAddressMapper", "remittanceMapper", "purposeCodeMapper"})
    public PaymentModelMapperPsd2(CoreObjectsMapper coreObjectsMapper, AccountModelMapper accountModelMapper, TppRedirectUriMapper tppRedirectUriMapper, AmountModelMapper amountModelMapper, HrefLinkMapper hrefLinkMapper, StandardPaymentProductsResolver standardPaymentProductsResolver, ScaMethodsMapper scaMethodsMapper, Xs2aAddressMapper xs2aAddressMapper, RemittanceMapper remittanceMapper, PurposeCodeMapper purposeCodeMapper) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.accountModelMapper = accountModelMapper;
        this.tppRedirectUriMapper = tppRedirectUriMapper;
        this.amountModelMapper = amountModelMapper;
        this.hrefLinkMapper = hrefLinkMapper;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.scaMethodsMapper = scaMethodsMapper;
        this.xs2aAddressMapper = xs2aAddressMapper;
        this.remittanceMapper = remittanceMapper;
        this.purposeCodeMapper = purposeCodeMapper;
    }
}

