/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class PaymentCancellationLinks
extends AbstractLinks {
    private ScaApproachResolver scaApproachResolver;
    private RedirectLinkBuilder redirectLinkBuilder;
    private RedirectIdService redirectIdService;
    private boolean isExplicitMethod;

    public PaymentCancellationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, RedirectIdService redirectIdService, CancelPaymentResponse response, boolean isExplicitMethod) {
        super(httpUrl);
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.redirectIdService = redirectIdService;
        this.isExplicitMethod = isExplicitMethod;
        this.buildCancellationLinks(response);
    }

    private void buildCancellationLinks(CancelPaymentResponse body) {
        if (TransactionStatus.RJCT == body.getTransactionStatus()) {
            return;
        }
        String paymentId = body.getPaymentId();
        String paymentService = body.getPaymentType().getValue();
        String paymentProduct = body.getPaymentProduct();
        String authorisationId = body.getAuthorizationId();
        String internalRequestId = body.getInternalRequestId();
        this.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentService, paymentProduct, paymentId));
        this.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentService, paymentProduct, paymentId));
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(scaApproach)) {
            this.addEmbeddedDecoupledRelatedLinks(paymentService, paymentProduct, paymentId, authorisationId);
        } else if (scaApproach == ScaApproach.REDIRECT) {
            this.addRedirectRelatedLinks(paymentService, paymentProduct, paymentId, authorisationId, internalRequestId);
        } else if (scaApproach == ScaApproach.OAUTH) {
            this.setScaOAuth(new HrefType("scaOAuth"));
        }
    }

    private void addEmbeddedDecoupledRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorisationId) {
        if (this.isExplicitMethod) {
            this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations", paymentService, paymentProduct, paymentId));
        } else {
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
            this.setUpdatePsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        }
    }

    private void addRedirectRelatedLinks(String paymentService, String paymentProduct, String paymentId, String authorisationId, String internalRequestId) {
        if (this.isExplicitMethod) {
            this.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations", paymentService, paymentProduct, paymentId));
        } else {
            String redirectId = this.redirectIdService.generateRedirectId(authorisationId);
            String scaRedirectLink = this.redirectLinkBuilder.buildPaymentCancellationScaRedirectLink(paymentId, redirectId, internalRequestId);
            this.setScaRedirect(new HrefType(scaRedirectLink));
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        }
    }
}

