/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.consent.api.service.PisAuthorisationServiceEncrypted;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.service.validator.EndpointAccessChecker;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PisEndpointAccessCheckerService
extends EndpointAccessChecker {
    private final PisAuthorisationServiceEncrypted pisAuthorisationServiceEncrypted;

    public boolean isEndpointAccessible(String authorisationId, PaymentAuthorisationType authorisationType) {
        Optional authorisationResponse = Optional.empty();
        if (authorisationType == PaymentAuthorisationType.CREATED) {
            authorisationResponse = this.pisAuthorisationServiceEncrypted.getPisAuthorisationById(authorisationId);
        } else if (authorisationType == PaymentAuthorisationType.CANCELLED) {
            authorisationResponse = this.pisAuthorisationServiceEncrypted.getPisCancellationAuthorisationById(authorisationId);
        }
        return authorisationResponse.map(p -> this.isAccessible(p.getChosenScaApproach(), p.getScaStatus())).orElse(true);
    }

    @ConstructorProperties(value={"pisAuthorisationServiceEncrypted"})
    public PisEndpointAccessCheckerService(PisAuthorisationServiceEncrypted pisAuthorisationServiceEncrypted) {
        this.pisAuthorisationServiceEncrypted = pisAuthorisationServiceEncrypted;
    }
}

