/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aPeriodicPaymentMapperImpl
implements SpiToXs2aPeriodicPaymentMapper {
    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aAddressMapper spiToXs2aAddressMapper;
    @Autowired
    private RemittanceMapper remittanceMapper;

    @Override
    public PeriodicPayment mapToXs2aPeriodicPayment(SpiPeriodicPayment payment) {
        if (payment == null) {
            return null;
        }
        PeriodicPayment periodicPayment = new PeriodicPayment();
        periodicPayment.setTransactionStatus(payment.getPaymentStatus());
        periodicPayment.setPaymentId(payment.getPaymentId());
        periodicPayment.setPaymentProduct(payment.getPaymentProduct());
        periodicPayment.setStatusChangeTimestamp(payment.getStatusChangeTimestamp());
        periodicPayment.setCreditorId(payment.getCreditorId());
        periodicPayment.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodicPayment.setInstructionIdentification(payment.getInstructionIdentification());
        periodicPayment.setDebtorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(payment.getDebtorAccount()));
        periodicPayment.setUltimateDebtor(payment.getUltimateDebtor());
        periodicPayment.setInstructedAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(payment.getInstructedAmount()));
        periodicPayment.setCreditorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(payment.getCreditorAccount()));
        periodicPayment.setCreditorAgent(payment.getCreditorAgent());
        periodicPayment.setCreditorName(payment.getCreditorName());
        periodicPayment.setCreditorAddress(this.spiToXs2aAddressMapper.mapToAddress(payment.getCreditorAddress()));
        periodicPayment.setUltimateCreditor(payment.getUltimateCreditor());
        periodicPayment.setPurposeCode(payment.getPurposeCode());
        periodicPayment.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodicPayment.setRemittanceInformationStructured(this.remittanceMapper.mapToRemittance(payment.getRemittanceInformationStructured()));
        periodicPayment.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        periodicPayment.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        periodicPayment.setStartDate(payment.getStartDate());
        periodicPayment.setExecutionRule(payment.getExecutionRule());
        periodicPayment.setEndDate(payment.getEndDate());
        periodicPayment.setPaymentType(payment.getPaymentType());
        periodicPayment.setFrequency(payment.getFrequency());
        periodicPayment.setDayOfExecution(payment.getDayOfExecution());
        return periodicPayment;
    }
}

