/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.pis;

import de.adorsys.psd2.model.Error403NGPIS;
import de.adorsys.psd2.model.TppMessage403PIS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIS403ErrorMapper
extends Psd2ErrorMapper<MessageError, Error403NGPIS> {
    @Override
    public Function<MessageError, Error403NGPIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.FORBIDDEN;
    }

    private Error403NGPIS mapToPsd2Error(MessageError messageError) {
        return new Error403NGPIS().tppMessages(this.mapToTppMessage403PIS(messageError.getTppMessages()));
    }

    private List<TppMessage403PIS> mapToTppMessage403PIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage403PIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(m.getMessageErrorCode().getName()).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

