/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Size;

@ApiModel(description="Authentication object", value="AuthenticationObject")
public class Xs2aAuthenticationObject {
    @ApiModelProperty(value="Type of the authentication method", required=true)
    private String authenticationType;
    @ApiModelProperty(value="Version can be used by differentiating authentication tools used within performing OTP generation in the same authentication type")
    private String authenticationVersion;
    @ApiModelProperty(value="Provided by the ASPSP for the later identification of the authentication method selection.", required=true)
    @Size(max=35)
    private @Size(max=35) String authenticationMethodId;
    @ApiModelProperty(value="Name of the authentication method", required=false, example="redirect")
    private String name;
    @ApiModelProperty(value="Detailed information about the sca method for the PSU", required=false)
    private String explanation;
    @JsonIgnore
    private boolean decoupled;

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public String getAuthenticationVersion() {
        return this.authenticationVersion;
    }

    public String getAuthenticationMethodId() {
        return this.authenticationMethodId;
    }

    public String getName() {
        return this.name;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public boolean isDecoupled() {
        return this.decoupled;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public void setAuthenticationVersion(String authenticationVersion) {
        this.authenticationVersion = authenticationVersion;
    }

    public void setAuthenticationMethodId(String authenticationMethodId) {
        this.authenticationMethodId = authenticationMethodId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public void setDecoupled(boolean decoupled) {
        this.decoupled = decoupled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xs2aAuthenticationObject)) {
            return false;
        }
        Xs2aAuthenticationObject other = (Xs2aAuthenticationObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authenticationType = this.getAuthenticationType();
        String other$authenticationType = other.getAuthenticationType();
        if (this$authenticationType == null ? other$authenticationType != null : !this$authenticationType.equals(other$authenticationType)) {
            return false;
        }
        String this$authenticationVersion = this.getAuthenticationVersion();
        String other$authenticationVersion = other.getAuthenticationVersion();
        if (this$authenticationVersion == null ? other$authenticationVersion != null : !this$authenticationVersion.equals(other$authenticationVersion)) {
            return false;
        }
        String this$authenticationMethodId = this.getAuthenticationMethodId();
        String other$authenticationMethodId = other.getAuthenticationMethodId();
        if (this$authenticationMethodId == null ? other$authenticationMethodId != null : !this$authenticationMethodId.equals(other$authenticationMethodId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$explanation = this.getExplanation();
        String other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
            return false;
        }
        return this.isDecoupled() == other.isDecoupled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Xs2aAuthenticationObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authenticationType = this.getAuthenticationType();
        result = result * 59 + ($authenticationType == null ? 43 : $authenticationType.hashCode());
        String $authenticationVersion = this.getAuthenticationVersion();
        result = result * 59 + ($authenticationVersion == null ? 43 : $authenticationVersion.hashCode());
        String $authenticationMethodId = this.getAuthenticationMethodId();
        result = result * 59 + ($authenticationMethodId == null ? 43 : $authenticationMethodId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $explanation = this.getExplanation();
        result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
        result = result * 59 + (this.isDecoupled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Xs2aAuthenticationObject(authenticationType=" + this.getAuthenticationType() + ", authenticationVersion=" + this.getAuthenticationVersion() + ", authenticationMethodId=" + this.getAuthenticationMethodId() + ", name=" + this.getName() + ", explanation=" + this.getExplanation() + ", decoupled=" + this.isDecoupled() + ")";
    }
}

