/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.AccountReferenceCollector;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

@ApiModel(description="Request creates an account information consent resource at the ASPSP regarding access to accounts specified in this request")
public class CreateConsentReq
implements AccountReferenceCollector {
    @ApiModelProperty(value="Requested access services.", required=true)
    @NotNull
    private Xs2aAccountAccess access;
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for one access to the account data", required=true)
    @NotNull
    private boolean recurringIndicator;
    @ApiModelProperty(value="This parameter is requesting a valid until date for the requested consent. The content is the local ASPSP date in ISODate Format", required=true, example="2019-10-30")
    @NotNull
    private LocalDate validUntil;
    @ApiModelProperty(value="This field indicates the requested maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    @NotNull
    private int frequencyPerDay;
    @ApiModelProperty(value="If 'true' indicates that a payment initiation service will be addressed in the same 'session'", required=true)
    @NotNull
    private boolean combinedServiceIndicator;
    @ApiModelProperty(value="TPP redirect URI object'")
    private TppRedirectUri tppRedirectUri;

    @Override
    @JsonIgnore
    public Set<AccountReference> getAccountReferences() {
        return this.getReferenceSet(this.access.getAccounts(), this.access.getBalances(), this.access.getTransactions());
    }

    @JsonIgnore
    public boolean isGlobalOrAllAccountsAccessConsent() {
        return this.isConsentGlobal() || this.isConsentForAllAvailableAccounts();
    }

    @SafeVarargs
    private final Set<AccountReference> getReferenceSet(List<AccountReference> ... referencesList) {
        return Arrays.stream(referencesList).map(this::getReferenceList).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private List<AccountReference> getReferenceList(List<AccountReference> reference) {
        return Optional.ofNullable(reference).orElseGet(Collections::emptyList);
    }

    private boolean isConsentGlobal() {
        return this.access.isNotEmpty() && this.access.getAllPsd2() == AccountAccessType.ALL_ACCOUNTS;
    }

    @JsonIgnore
    public boolean isConsentForAllAvailableAccounts() {
        return this.access.getAvailableAccounts() == AccountAccessType.ALL_ACCOUNTS || this.access.getAvailableAccountsWithBalance() == AccountAccessType.ALL_ACCOUNTS;
    }

    @JsonIgnore
    public boolean isOneAccessType() {
        return !this.isRecurringIndicator();
    }

    public Xs2aAccountAccess getAccess() {
        return this.access;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public TppRedirectUri getTppRedirectUri() {
        return this.tppRedirectUri;
    }

    public void setAccess(Xs2aAccountAccess access) {
        this.access = access;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setFrequencyPerDay(int frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setTppRedirectUri(TppRedirectUri tppRedirectUri) {
        this.tppRedirectUri = tppRedirectUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateConsentReq)) {
            return false;
        }
        CreateConsentReq other = (CreateConsentReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Xs2aAccountAccess this$access = this.getAccess();
        Xs2aAccountAccess other$access = other.getAccess();
        if (this$access == null ? other$access != null : !((Object)this$access).equals(other$access)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        TppRedirectUri this$tppRedirectUri = this.getTppRedirectUri();
        TppRedirectUri other$tppRedirectUri = other.getTppRedirectUri();
        return !(this$tppRedirectUri == null ? other$tppRedirectUri != null : !this$tppRedirectUri.equals(other$tppRedirectUri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateConsentReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Xs2aAccountAccess $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : ((Object)$access).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + this.getFrequencyPerDay();
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        TppRedirectUri $tppRedirectUri = this.getTppRedirectUri();
        result = result * 59 + ($tppRedirectUri == null ? 43 : $tppRedirectUri.hashCode());
        return result;
    }

    public String toString() {
        return "CreateConsentReq(access=" + this.getAccess() + ", recurringIndicator=" + this.isRecurringIndicator() + ", validUntil=" + this.getValidUntil() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", tppRedirectUri=" + this.getTppRedirectUri() + ")";
    }
}

