package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountDetails;
import de.adorsys.psd2.model.AccountDetails.UsageEnum;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.ReadAccountBalanceResponse200;
import de.adorsys.psd2.model.ReportExchangeRate;
import de.adorsys.psd2.model.TransactionDetails;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-01-31T11:02:50+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class AccountModelMapperImpl extends AccountModelMapper {

    @Autowired
    private AmountModelMapper amountModelMapper;
    @Autowired
    private PurposeCodeMapper purposeCodeMapper;

    @Override
    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReference accountReference1 = new AccountReference();

        accountReference1.setCurrency( accountReferenceCurrencyCurrencyCode( accountReference ) );
        accountReference1.setIban( accountReference.getIban() );
        accountReference1.setBban( accountReference.getBban() );
        accountReference1.setPan( accountReference.getPan() );
        accountReference1.setMaskedPan( accountReference.getMaskedPan() );
        accountReference1.setMsisdn( accountReference.getMsisdn() );

        return accountReference1;
    }

    @Override
    public List<AccountReference> mapToAccountReferences(List<de.adorsys.psd2.xs2a.core.profile.AccountReference> accountReferences) {
        if ( accountReferences == null ) {
            return null;
        }

        List<AccountReference> list = new ArrayList<AccountReference>( accountReferences.size() );
        for ( de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference : accountReferences ) {
            list.add( mapToAccountReference( accountReference ) );
        }

        return list;
    }

    @Override
    public AccountDetails mapToAccountDetails(Xs2aAccountDetails accountDetails) {
        if ( accountDetails == null ) {
            return null;
        }

        AccountDetails accountDetails1 = new AccountDetails();

        accountDetails1.setUsage( xs2aUsageTypeToUsageEnum( accountDetails.getUsageType() ) );
        accountDetails1.setStatus( accountStatusToAccountStatus( accountDetails.getAccountStatus() ) );
        accountDetails1.setResourceId( accountDetails.getResourceId() );
        accountDetails1.setIban( accountDetails.getIban() );
        accountDetails1.setBban( accountDetails.getBban() );
        accountDetails1.setMsisdn( accountDetails.getMsisdn() );
        if ( accountDetails.getCurrency() != null ) {
            accountDetails1.setCurrency( accountDetails.getCurrency().getCurrencyCode() );
        }
        accountDetails1.setName( accountDetails.getName() );
        accountDetails1.setProduct( accountDetails.getProduct() );
        if ( accountDetails.getCashAccountType() != null ) {
            accountDetails1.setCashAccountType( accountDetails.getCashAccountType().name() );
        }
        accountDetails1.setBic( accountDetails.getBic() );
        accountDetails1.setLinkedAccounts( accountDetails.getLinkedAccounts() );
        accountDetails1.setDetails( accountDetails.getDetails() );
        accountDetails1.setBalances( mapToBalanceList( accountDetails.getBalances() ) );

        accountDetails1.setLinks( hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()) );

        return accountDetails1;
    }

    @Override
    public Balance mapToBalance(Xs2aBalance balance) {
        if ( balance == null ) {
            return null;
        }

        Balance balance1 = new Balance();

        balance1.setBalanceAmount( amountModelMapper.mapToAmount( balance.getBalanceAmount() ) );
        balance1.setCreditLimitIncluded( balance.getCreditLimitIncluded() );
        balance1.setReferenceDate( balance.getReferenceDate() );
        balance1.setLastCommittedTransaction( balance.getLastCommittedTransaction() );

        balance1.setLastChangeDateTime( mapToOffsetDateTime(balance.getLastChangeDateTime()) );
        balance1.setBalanceType( mapToBalanceType(balance.getBalanceType()) );

        return balance1;
    }

    @Override
    public ReadAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport balancesReport) {
        if ( balancesReport == null ) {
            return null;
        }

        ReadAccountBalanceResponse200 readAccountBalanceResponse200 = new ReadAccountBalanceResponse200();

        readAccountBalanceResponse200.setAccount( mapToAccountReference( balancesReport.getXs2aAccountReference() ) );
        readAccountBalanceResponse200.setBalances( mapToBalanceList( balancesReport.getBalances() ) );

        return readAccountBalanceResponse200;
    }

    @Override
    public AccountReport mapToAccountReport(Xs2aAccountReport accountReport) {
        if ( accountReport == null ) {
            return null;
        }

        AccountReport accountReport1 = new AccountReport();

        accountReport1.setBooked( mapToTransactionList( accountReport.getBooked() ) );
        accountReport1.setPending( mapToTransactionList( accountReport.getPending() ) );

        accountReport1.setLinks( hrefLinkMapper.mapToLinksMap(accountReport.getLinks()) );

        return accountReport1;
    }

    @Override
    public TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport transactionsReport) {
        if ( transactionsReport == null ) {
            return null;
        }

        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();

        transactionsResponse200Json.setTransactions( mapToAccountReport( transactionsReport.getAccountReport() ) );
        transactionsResponse200Json.setAccount( mapToAccountReference( transactionsReport.getAccountReference() ) );
        transactionsResponse200Json.setBalances( mapToBalanceList( transactionsReport.getBalances() ) );

        transactionsResponse200Json.setLinks( hrefLinkMapper.mapToLinksMap(transactionsReport.getLinks()) );

        return transactionsResponse200Json;
    }

    @Override
    public TransactionDetails mapToTransaction(Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }

        TransactionDetails transactionDetails = new TransactionDetails();

        transactionDetails.setBankTransactionCode( transactionsBankTransactionCodeCodeCode( transactions ) );
        transactionDetails.setTransactionAmount( amountModelMapper.mapToAmount( transactions.getAmount() ) );
        transactionDetails.setTransactionId( transactions.getTransactionId() );
        transactionDetails.setEntryReference( transactions.getEntryReference() );
        transactionDetails.setEndToEndId( transactions.getEndToEndId() );
        transactionDetails.setMandateId( transactions.getMandateId() );
        transactionDetails.setCheckId( transactions.getCheckId() );
        transactionDetails.setCreditorId( transactions.getCreditorId() );
        transactionDetails.setBookingDate( transactions.getBookingDate() );
        transactionDetails.setValueDate( transactions.getValueDate() );
        transactionDetails.setCreditorName( transactions.getCreditorName() );
        transactionDetails.setCreditorAccount( mapToAccountReference( transactions.getCreditorAccount() ) );
        transactionDetails.setCreditorAgent( transactions.getCreditorAgent() );
        transactionDetails.setUltimateCreditor( transactions.getUltimateCreditor() );
        transactionDetails.setDebtorName( transactions.getDebtorName() );
        transactionDetails.setDebtorAccount( mapToAccountReference( transactions.getDebtorAccount() ) );
        transactionDetails.setDebtorAgent( transactions.getDebtorAgent() );
        transactionDetails.setUltimateDebtor( transactions.getUltimateDebtor() );
        transactionDetails.setRemittanceInformationUnstructured( transactions.getRemittanceInformationUnstructured() );
        transactionDetails.setRemittanceInformationStructured( transactions.getRemittanceInformationStructured() );
        transactionDetails.setPurposeCode( purposeCodeMapper.mapToPurposeCode( transactions.getPurposeCode() ) );
        transactionDetails.setProprietaryBankTransactionCode( transactions.getProprietaryBankTransactionCode() );
        transactionDetails.setBalanceAfterTransaction( mapToBalance( transactions.getBalanceAfterTransaction() ) );

        transactionDetails.setCurrencyExchange( mapToReportExchanges(transactions.getExchangeRate()) );

        return transactionDetails;
    }

    @Override
    protected ReportExchangeRate mapToReportExchangeRate(Xs2aExchangeRate xs2aExchangeRate) {
        if ( xs2aExchangeRate == null ) {
            return null;
        }

        ReportExchangeRate reportExchangeRate = new ReportExchangeRate();

        reportExchangeRate.setSourceCurrency( xs2aExchangeRate.getSourceCurrency() );
        reportExchangeRate.setExchangeRate( xs2aExchangeRate.getExchangeRate() );
        reportExchangeRate.setUnitCurrency( xs2aExchangeRate.getUnitCurrency() );
        reportExchangeRate.setTargetCurrency( xs2aExchangeRate.getTargetCurrency() );
        reportExchangeRate.setQuotationDate( xs2aExchangeRate.getQuotationDate() );
        reportExchangeRate.setContractIdentification( xs2aExchangeRate.getContractIdentification() );

        return reportExchangeRate;
    }

    private String accountReferenceCurrencyCurrencyCode(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }
        Currency currency = accountReference.getCurrency();
        if ( currency == null ) {
            return null;
        }
        String currencyCode = currency.getCurrencyCode();
        if ( currencyCode == null ) {
            return null;
        }
        return currencyCode;
    }

    protected UsageEnum xs2aUsageTypeToUsageEnum(Xs2aUsageType xs2aUsageType) {
        if ( xs2aUsageType == null ) {
            return null;
        }

        UsageEnum usageEnum;

        switch ( xs2aUsageType ) {
            case PRIV: usageEnum = UsageEnum.PRIV;
            break;
            case ORGA: usageEnum = UsageEnum.ORGA;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + xs2aUsageType );
        }

        return usageEnum;
    }

    protected AccountStatus accountStatusToAccountStatus(de.adorsys.psd2.xs2a.domain.account.AccountStatus accountStatus) {
        if ( accountStatus == null ) {
            return null;
        }

        AccountStatus accountStatus1;

        switch ( accountStatus ) {
            case ENABLED: accountStatus1 = AccountStatus.ENABLED;
            break;
            case DELETED: accountStatus1 = AccountStatus.DELETED;
            break;
            case BLOCKED: accountStatus1 = AccountStatus.BLOCKED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountStatus );
        }

        return accountStatus1;
    }

    private String transactionsBankTransactionCodeCodeCode(Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        BankTransactionCode bankTransactionCodeCode = transactions.getBankTransactionCodeCode();
        if ( bankTransactionCodeCode == null ) {
            return null;
        }
        String code = bankTransactionCodeCode.getCode();
        if ( code == null ) {
            return null;
        }
        return code;
    }
}
