/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.converter.LocalDateConverter;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.raw.FieldExtractor;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aBodyDateFormatter;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateField;
import java.beans.ConstructorProperties;
import java.time.format.DateTimeParseException;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class DateFieldValidator {
    private static final String DAY_OF_EXECUTION_FIELD_NAME = "dayOfExecution";
    private static final String DAY_OF_MONTH_REGEX = "(0?[1-9]|[12]\\d|3[01])";
    private final ErrorBuildingService errorBuildingService;
    private final LocalDateConverter localDateConverter;
    private final FieldExtractor fieldExtractor;

    public MessageError validateDateFormat(HttpServletRequest request, EnumSet<Xs2aRequestBodyDateField> fields, MessageError messageError) {
        return this.validateRawDataDates(request, fields, messageError);
    }

    public void validateDayOfExecution(HttpServletRequest request, MessageError messageError) {
        this.fieldExtractor.extractField(request, DAY_OF_EXECUTION_FIELD_NAME, messageError).ifPresent(day -> this.validateDayOfExecutionValue((String)day, messageError));
    }

    public MessageError validateRawDataDates(HttpServletRequest request, EnumSet<Xs2aRequestBodyDateField> fields, MessageError messageError) {
        for (Xs2aRequestBodyDateField field : fields) {
            this.fieldExtractor.extractField(request, field.getFieldName(), messageError).ifPresent(date -> this.convert(field.getFieldName(), (String)date, field.getFormatter(), messageError));
        }
        return messageError;
    }

    private void convert(String key, String value, Xs2aBodyDateFormatter formatter, MessageError messageError) {
        try {
            this.localDateConverter.convert(value, formatter.getFormatter());
        }
        catch (DateTimeParseException ex) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_DATE_FIELD, key, formatter.name(), formatter.getPattern()));
        }
    }

    private void validateDayOfExecutionValue(String value, MessageError messageError) {
        if (!this.isNumberADayOfMonth(value)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_INVALID_DAY_OF_EXECUTION));
        }
    }

    private boolean isNumberADayOfMonth(@NotNull String value) {
        return value.matches(DAY_OF_MONTH_REGEX);
    }

    @ConstructorProperties(value={"errorBuildingService", "localDateConverter", "fieldExtractor"})
    public DateFieldValidator(ErrorBuildingService errorBuildingService, LocalDateConverter localDateConverter, FieldExtractor fieldExtractor) {
        this.errorBuildingService = errorBuildingService;
        this.localDateConverter = localDateConverter;
        this.fieldExtractor = fieldExtractor;
    }
}

