/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.xs2a.component.logger.TppLogger;
import de.adorsys.psd2.xs2a.component.logger.TppRequestLogBuilder;
import de.adorsys.psd2.xs2a.component.logger.TppResponseLogBuilder;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.context.LoggingContextService;
import de.adorsys.psd2.xs2a.web.PathParameterExtractor;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PaymentLoggingInterceptor
extends HandlerInterceptorAdapter {
    private static final String NOT_EXIST_IN_URI = "Not exist in URI";
    private final TppService tppService;
    private final RedirectIdService redirectIdService;
    private final RequestProviderService requestProviderService;
    private final LoggingContextService loggingContextService;
    private final PathParameterExtractor pathParameterExtractor;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Map<String, String> pathVariables = this.pathParameterExtractor.extractParameters(request);
        String paymentId = Optional.ofNullable(pathVariables).map(vr -> (String)vr.get("paymentId")).orElse(NOT_EXIST_IN_URI);
        ((TppRequestLogBuilder)((TppRequestLogBuilder)((TppRequestLogBuilder)TppLogger.logRequest(request).withTpp(this.tppService.getTppInfo()).withInternalRequestId(this.requestProviderService.getInternalRequestId())).withXRequestId()).withRequestUri().withParam("Payment ID", paymentId)).perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ((TppResponseLogBuilder)((TppResponseLogBuilder)((TppResponseLogBuilder)((TppResponseLogBuilder)TppLogger.logResponse(response).withTpp(this.tppService.getTppInfo()).withInternalRequestId(this.requestProviderService.getInternalRequestId())).withXRequestId()).withResponseStatus().withOptionalRedirectId(this.redirectIdService.getRedirectId()).withParam("transactionStatus", this.loggingContextService.getTransactionStatus())).withParam("scaStatus", this.loggingContextService.getScaStatus())).perform();
    }

    @ConstructorProperties(value={"tppService", "redirectIdService", "requestProviderService", "loggingContextService", "pathParameterExtractor"})
    public PaymentLoggingInterceptor(TppService tppService, RedirectIdService redirectIdService, RequestProviderService requestProviderService, LoggingContextService loggingContextService, PathParameterExtractor pathParameterExtractor) {
        this.tppService = tppService;
        this.redirectIdService = redirectIdService;
        this.requestProviderService = requestProviderService;
        this.loggingContextService = loggingContextService;
        this.pathParameterExtractor = pathParameterExtractor;
    }
}

