/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
public class SwaggerConfig {
    private static final String DEFAULT_PSD2_API_LOCATION = "/psd2-api_1.3.4_20190717v1.yaml";
    @Value(value="${xs2a.swagger.psd2.api.location:}")
    private String customPsd2ApiLocation;

    @Bean(name={"api"})
    public Docket apiDocklet() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(new ApiInfoBuilder().build()).select().paths(Predicates.not((Predicate)PathSelectors.regex((String)"/error.*?"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/connect.*"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/management.*"))).build();
    }

    @Bean
    @Primary
    public SwaggerResourcesProvider swaggerResourcesProvider() {
        return () -> {
            SwaggerResource swaggerResource = new SwaggerResource();
            swaggerResource.setLocation(this.resolveYamlLocation());
            return Collections.singletonList(swaggerResource);
        };
    }

    private String resolveYamlLocation() {
        if (StringUtils.isBlank((CharSequence)this.customPsd2ApiLocation)) {
            return DEFAULT_PSD2_API_LOCATION;
        }
        return this.customPsd2ApiLocation;
    }
}

