/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsDownloadResponse;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.AccountController;
import de.adorsys.psd2.xs2a.web.link.TransactionsReportAccountLinks;
import de.adorsys.psd2.xs2a.web.link.TransactionsReportDownloadLinks;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TransactionAspect
extends AbstractLinkAspect<AccountController> {
    private static final Logger log = LoggerFactory.getLogger(TransactionAspect.class);

    public TransactionAspect(AspspProfileService aspspProfileService) {
        super(aspspProfileService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ais.TransactionService.getTransactionsReportByPeriod(..)) && args(request)", returning="result", argNames="result,request")
    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(ResponseObject<Xs2aTransactionsReport> result, Xs2aTransactionsReportByPeriodRequest request) {
        if (!result.hasError()) {
            Xs2aTransactionsReport transactionsReport = result.getBody();
            transactionsReport.setLinks(new TransactionsReportDownloadLinks(this.getHttpUrl(), request.getAccountId(), request.isWithBalance(), transactionsReport.getDownloadId()));
            Xs2aAccountReport accountReport = transactionsReport.getAccountReport();
            if (transactionsReport.getAccountReport() != null) {
                accountReport.setLinks(new TransactionsReportAccountLinks(this.getHttpUrl(), request.getAccountId(), request.isWithBalance()));
            }
        }
        return result;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ais.TransactionService.getTransactionDetails(..)) && args( consentID, accountId, resourceId, requestUri)", returning="result", argNames="result,consentID,accountId,resourceId,requestUri")
    public ResponseObject<Transactions> getTransactionDetailsAspect(ResponseObject<Transactions> result, String consentID, String accountId, String resourceId, String requestUri) {
        return result;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ais.TransactionService.downloadTransactions(..)) && args( consentId, accountId, downloadId)", returning="result", argNames="result,consentId,accountId,downloadId")
    public ResponseObject<Xs2aTransactionsDownloadResponse> downloadTransactions(ResponseObject<Xs2aTransactionsDownloadResponse> result, String consentId, String accountId, String downloadId) {
        return result;
    }
}

