/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.CommonPaymentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreatePisAuthorisationValidator
extends AbstractPisValidator<CommonPaymentObject> {
    private static final Logger log = LoggerFactory.getLogger(CreatePisAuthorisationValidator.class);

    public CreatePisAuthorisationValidator(RequestProviderService requestProviderService) {
        super(requestProviderService);
    }

    @Override
    protected ValidationResult executeBusinessValidation(CommonPaymentObject paymentObject) {
        PisCommonPaymentResponse pisCommonPaymentResponse = paymentObject.getPisCommonPaymentResponse();
        if (pisCommonPaymentResponse.getTransactionStatus() == TransactionStatus.RJCT) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Creation of PIS authorisation has failed: payment has been rejected", new Object[]{this.getRequestProviderService().getInternalRequestId(), this.getRequestProviderService().getRequestId(), pisCommonPaymentResponse.getExternalId()});
            return ValidationResult.invalid(ErrorType.PIS_403, MessageErrorCode.RESOURCE_EXPIRED_403);
        }
        return ValidationResult.valid();
    }
}

