/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.cancellation.GetPaymentCancellationAuthorisationScaStatusPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetPaymentCancellationAuthorisationScaStatusValidator
extends AbstractPisValidator<GetPaymentCancellationAuthorisationScaStatusPO> {
    private static final Logger log = LoggerFactory.getLogger(GetPaymentCancellationAuthorisationScaStatusValidator.class);
    private final PisAuthorisationValidator pisAuthorisationValidator;

    public GetPaymentCancellationAuthorisationScaStatusValidator(RequestProviderService requestProviderService, PisAuthorisationValidator pisAuthorisationValidator) {
        super(requestProviderService);
        this.pisAuthorisationValidator = pisAuthorisationValidator;
    }

    @Override
    protected ValidationResult executeBusinessValidation(GetPaymentCancellationAuthorisationScaStatusPO paymentObject) {
        PisCommonPaymentResponse response = paymentObject.getPisCommonPaymentResponse();
        String authorisationId = paymentObject.getAuthorisationId();
        ValidationResult authorisationValidationResult = this.pisAuthorisationValidator.validate(authorisationId, response);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        return ValidationResult.valid();
    }
}

