/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.PaymentTypeAndInfoProvider;
import de.adorsys.psd2.xs2a.service.validator.tpp.PisTppInfoValidator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractPisValidator<T extends PaymentTypeAndInfoProvider>
implements BusinessValidator<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPisValidator.class);
    private PisTppInfoValidator pisTppInfoValidator;
    private RequestProviderService requestProviderService;

    public AbstractPisValidator(RequestProviderService requestProviderService) {
        this.requestProviderService = requestProviderService;
    }

    @Override
    @NotNull
    public ValidationResult validate(@NotNull T object) {
        ValidationResult paymentTypeAndProductValidationResult = this.validatePaymentTypeAndProduct(object);
        if (paymentTypeAndProductValidationResult.isNotValid()) {
            return paymentTypeAndProductValidationResult;
        }
        TppInfo tppInfoInPayment = object.getTppInfo();
        ValidationResult tppValidationResult = this.pisTppInfoValidator.validateTpp(tppInfoInPayment);
        if (tppValidationResult.isNotValid()) {
            return tppValidationResult;
        }
        return this.executeBusinessValidation(object);
    }

    private ValidationResult validatePaymentTypeAndProduct(T object) {
        PisCommonPaymentResponse paymentResponse = object.getPisCommonPaymentResponse();
        if (!object.getPaymentType().equals((Object)paymentResponse.getPaymentType())) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Payment validation has failed: payment type [{}] is incorrect", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentResponse.getExternalId(), object.getPaymentType()});
            return ValidationResult.invalid(ErrorType.PIS_405, TppMessageInformation.of(MessageErrorCode.SERVICE_INVALID_405_FOR_PAYMENT));
        }
        if (!object.getPaymentProduct().equals(paymentResponse.getPaymentProduct())) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment ID: [{}]. Payment validation has failed: payment product [{}] is incorrect", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentResponse.getExternalId(), object.getPaymentProduct()});
            return ValidationResult.invalid(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.PRODUCT_INVALID_FOR_PAYMENT));
        }
        return ValidationResult.valid();
    }

    protected abstract ValidationResult executeBusinessValidation(T var1);

    @Autowired
    public void setPisValidators(PisTppInfoValidator pisTppInfoValidator) {
        this.pisTppInfoValidator = pisTppInfoValidator;
    }

    public RequestProviderService getRequestProviderService() {
        return this.requestProviderService;
    }
}

