/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.consent;

import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.PsuDataInInitialRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.SupportedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.CreateConsentRequestObject;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class CreateConsentRequestValidator
implements BusinessValidator<CreateConsentRequestObject> {
    private final AspspProfileServiceWrapper aspspProfileService;
    private final ScaApproachResolver scaApproachResolver;
    private final PsuDataInInitialRequestValidator psuDataInInitialRequestValidator;
    private final SupportedAccountReferenceValidator supportedAccountReferenceValidator;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull CreateConsentRequestObject requestObject) {
        ValidationResult psuDataValidationResult = this.psuDataInInitialRequestValidator.validate(requestObject.getPsuIdData());
        if (psuDataValidationResult.isNotValid()) {
            return psuDataValidationResult;
        }
        CreateConsentReq request = requestObject.getCreateConsentReq();
        ValidationResult supportedAccountReferenceValidationResult = this.supportedAccountReferenceValidator.validate((Collection<AccountReference>)request.getAccountReferences());
        if (supportedAccountReferenceValidationResult.isNotValid()) {
            return supportedAccountReferenceValidationResult;
        }
        if (this.isNotSupportedGlobalConsentForAllPsd2(request)) {
            return ValidationResult.invalid(ErrorType.AIS_405, MessageErrorCode.SERVICE_INVALID_400_FOR_GLOBAL_CONSENT);
        }
        if (this.isNotSupportedBankOfferedConsent(request)) {
            return ValidationResult.invalid(ErrorType.AIS_405, MessageErrorCode.SERVICE_INVALID_400);
        }
        if (this.isNotSupportedAvailableAccounts(request)) {
            return ValidationResult.invalid(ErrorType.AIS_405, MessageErrorCode.SERVICE_INVALID_400);
        }
        if (this.isNotSupportedCombinedServiceIndicator(request)) {
            return ValidationResult.invalid(ErrorType.AIS_400, MessageErrorCode.SESSIONS_NOT_SUPPORTED);
        }
        return ValidationResult.valid();
    }

    private boolean isNotSupportedGlobalConsentForAllPsd2(CreateConsentReq request) {
        return this.isConsentGlobal(request) && this.aspspProfileService.getAllPsd2Support() == false;
    }

    private boolean isNotSupportedBankOfferedConsent(CreateConsentReq request) {
        if (this.isNotEmptyAccess(request.getAccess()).booleanValue()) {
            return false;
        }
        if (this.scaApproachResolver.resolveScaApproach() == ScaApproach.EMBEDDED) {
            return true;
        }
        return !this.aspspProfileService.isBankOfferedConsentSupported();
    }

    private boolean isConsentGlobal(CreateConsentReq request) {
        return this.isNotEmptyAccess(request.getAccess()) != false && request.getAccess().getAllPsd2() == AccountAccessType.ALL_ACCOUNTS;
    }

    private Boolean isNotEmptyAccess(Xs2aAccountAccess access) {
        return Optional.ofNullable(access).map(Xs2aAccountAccess::isNotEmpty).orElse(false);
    }

    private boolean isNotSupportedAvailableAccounts(CreateConsentReq request) {
        if (Objects.isNull(request.getAccess().getAvailableAccounts())) {
            return false;
        }
        return !this.aspspProfileService.isAvailableAccountsConsentSupported();
    }

    private boolean isNotSupportedCombinedServiceIndicator(CreateConsentReq request) {
        return request.isCombinedServiceIndicator() && !this.aspspProfileService.isCombinedServiceIndicator();
    }

    @ConstructorProperties(value={"aspspProfileService", "scaApproachResolver", "psuDataInInitialRequestValidator", "supportedAccountReferenceValidator"})
    public CreateConsentRequestValidator(AspspProfileServiceWrapper aspspProfileService, ScaApproachResolver scaApproachResolver, PsuDataInInitialRequestValidator psuDataInInitialRequestValidator, SupportedAccountReferenceValidator supportedAccountReferenceValidator) {
        this.aspspProfileService = aspspProfileService;
        this.scaApproachResolver = scaApproachResolver;
        this.psuDataInInitialRequestValidator = psuDataInInitialRequestValidator;
        this.supportedAccountReferenceValidator = supportedAccountReferenceValidator;
    }
}

