/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais;

import de.adorsys.psd2.xs2a.config.factory.AisScaStageAuthorisationFactory;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.stage.AisScaStage;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DecoupledAisAuthorizationService
implements AisAuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(DecoupledAisAuthorizationService.class);
    private final Xs2aAisConsentService aisConsentService;
    private final RequestProviderService requestProviderService;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final AisScaStageAuthorisationFactory scaStageAuthorisationFactory;

    @Override
    public Optional<CreateConsentAuthorizationResponse> createConsentAuthorization(PsuIdData psuData, String consentId) {
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}]. Create consent authorisation has failed. Consent not found by id.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            return Optional.empty();
        }
        return this.aisConsentService.createAisConsentAuthorization(consentId, ScaStatus.RECEIVED, psuData).map(auth -> {
            CreateConsentAuthorizationResponse resp = new CreateConsentAuthorizationResponse();
            resp.setConsentId(consentId);
            resp.setAuthorisationId(auth.getAuthorizationId());
            resp.setScaStatus(auth.getScaStatus());
            resp.setPsuIdData(psuData);
            return resp;
        });
    }

    @Override
    public UpdateConsentPsuDataResponse updateConsentPsuData(UpdateConsentPsuDataReq updatePsuData, AccountConsentAuthorization consentAuthorization) {
        AisScaStage service = (AisScaStage)this.scaStageAuthorisationFactory.getService("AIS_" + this.getScaApproachServiceType().name() + "_" + consentAuthorization.getScaStatus().name());
        UpdateConsentPsuDataResponse response = (UpdateConsentPsuDataResponse)service.apply(updatePsuData);
        if (response.hasError()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authentication-ID [{}], PSU-ID [{}]. Update consent authorisation has failed. Error msg: {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), updatePsuData.getConsentId(), updatePsuData.getAuthorizationId(), updatePsuData.getPsuData().getPsuId(), response.getMessageError()});
        } else {
            this.aisConsentService.updateConsentAuthorization(this.aisConsentMapper.mapToSpiUpdateConsentPsuDataReq(response, updatePsuData));
        }
        return response;
    }

    @Override
    public Optional<AccountConsentAuthorization> getAccountConsentAuthorizationById(String authorisationId, String consentId) {
        return this.aisConsentService.getAccountConsentAuthorizationById(authorisationId, consentId);
    }

    @Override
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.aisConsentService.getAuthorisationScaStatus(consentId, authorisationId);
    }

    @Override
    public ScaApproach getScaApproachServiceType() {
        return ScaApproach.DECOUPLED;
    }

    @ConstructorProperties(value={"aisConsentService", "requestProviderService", "aisConsentMapper", "scaStageAuthorisationFactory"})
    public DecoupledAisAuthorizationService(Xs2aAisConsentService aisConsentService, RequestProviderService requestProviderService, Xs2aAisConsentMapper aisConsentMapper, AisScaStageAuthorisationFactory scaStageAuthorisationFactory) {
        this.aisConsentService = aisConsentService;
        this.requestProviderService = requestProviderService;
        this.aisConsentMapper = aisConsentMapper;
        this.scaStageAuthorisationFactory = scaStageAuthorisationFactory;
    }
}

