/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.LoggingContextService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountDetailsMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetAccountDetailsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountDetailsService {
    private static final Logger log = LoggerFactory.getLogger(AccountDetailsService.class);
    private final AccountSpi accountSpi;
    private final SpiToXs2aAccountDetailsMapper accountDetailsMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final SpiErrorMapper spiErrorMapper;
    private final GetAccountDetailsValidator getAccountDetailsValidator;
    private final RequestProviderService requestProviderService;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final AccountHelperService accountHelperService;
    private final LoggingContextService loggingContextService;

    public ResponseObject<Xs2aAccountDetailsHolder> getAccountDetails(String consentId, String accountId, boolean withBalance, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_ACCOUNT_DETAILS_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        if (!accountConsentOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}]. Get account details failed. Account consent not found by id", new Object[]{internalRequestId, xRequestId, accountId, consentId});
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForCommonAccountRequest(accountId, withBalance, requestUri, accountConsent);
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID [{}], WithBalance [{}], RequestUri [{}]. Get account details - validation failed: {}", new Object[]{internalRequestId, xRequestId, accountId, consentId, withBalance, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<SpiAccountDetails> spiResponse = this.getSpiResponse(accountConsent, consentId, accountId, withBalance);
        if (spiResponse.hasError()) {
            return this.checkSpiResponse(consentId, accountId, spiResponse);
        }
        this.loggingContextService.storeConsentStatus(accountConsent.getConsentStatus());
        return this.getXs2aAccountDetailsHolderResponseObject(consentId, withBalance, requestUri, accountConsent, (SpiAccountDetails)spiResponse.getPayload());
    }

    private ValidationResult getValidationResultForCommonAccountRequest(String accountId, boolean withBalance, String requestUri, AccountConsent accountConsent) {
        CommonAccountRequestObject validatorObject = new CommonAccountRequestObject(accountConsent, accountId, withBalance, requestUri);
        return this.getAccountDetailsValidator.validate(validatorObject);
    }

    private SpiResponse<SpiAccountDetails> getSpiResponse(AccountConsent accountConsent, String consentId, String accountId, boolean withBalance) {
        Xs2aAccountAccess access = accountConsent.getAccess();
        SpiAccountReference requestedAccountReference = this.accountHelperService.findAccountReference(access.getAccounts(), accountId);
        return this.accountSpi.requestAccountDetailForAccount(this.accountHelperService.getSpiContextData(), withBalance, requestedAccountReference, this.consentMapper.mapToSpiAccountConsent(accountConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    private ResponseObject<Xs2aAccountDetailsHolder> checkSpiResponse(String consentId, String accountId, SpiResponse<SpiAccountDetails> spiResponse) {
        UUID internalRequestId = this.requestProviderService.getInternalRequestId();
        UUID xRequestId = this.requestProviderService.getRequestId();
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
        log.info("InR-ID: [{}], X-Request-ID: [{}], Account-ID [{}], Consent-ID: [{}]. Get account details failed: couldn't get account details. Error msg: [{}]", new Object[]{internalRequestId, xRequestId, accountId, consentId, errorHolder});
        return ResponseObject.builder().fail(errorHolder).build();
    }

    @NotNull
    private ResponseObject<Xs2aAccountDetailsHolder> getXs2aAccountDetailsHolderResponseObject(String consentId, boolean withBalance, String requestUri, AccountConsent accountConsent, SpiAccountDetails spiAccountDetails) {
        Xs2aAccountDetails accountDetails = this.accountDetailsMapper.mapToXs2aAccountDetails(spiAccountDetails);
        Xs2aAccountDetailsHolder xs2aAccountDetailsHolder = new Xs2aAccountDetailsHolder(accountDetails, accountConsent);
        ResponseObject<Xs2aAccountDetailsHolder> response = ResponseObject.builder().body(xs2aAccountDetailsHolder).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.accountHelperService.createActionStatus(withBalance, TypeAccess.ACCOUNT, response), requestUri, this.accountHelperService.needsToUpdateUsage(accountConsent), spiAccountDetails.getResourceId(), null);
        return response;
    }

    @ConstructorProperties(value={"accountSpi", "accountDetailsMapper", "aisConsentService", "consentMapper", "tppService", "xs2aEventService", "spiErrorMapper", "getAccountDetailsValidator", "requestProviderService", "aspspConsentDataProviderFactory", "accountHelperService", "loggingContextService"})
    public AccountDetailsService(AccountSpi accountSpi, SpiToXs2aAccountDetailsMapper accountDetailsMapper, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, Xs2aEventService xs2aEventService, SpiErrorMapper spiErrorMapper, GetAccountDetailsValidator getAccountDetailsValidator, RequestProviderService requestProviderService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AccountHelperService accountHelperService, LoggingContextService loggingContextService) {
        this.accountSpi = accountSpi;
        this.accountDetailsMapper = accountDetailsMapper;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.spiErrorMapper = spiErrorMapper;
        this.getAccountDetailsValidator = getAccountDetailsValidator;
        this.requestProviderService = requestProviderService;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.accountHelperService = accountHelperService;
        this.loggingContextService = loggingContextService;
    }
}

