/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.type;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AmountValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.config.PaymentValidationConfig;
import de.adorsys.psd2.xs2a.web.validator.body.payment.mapper.PaymentMapper;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.SinglePaymentTypeValidatorImpl;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PeriodicPaymentTypeValidatorImpl
extends SinglePaymentTypeValidatorImpl {
    @Autowired
    public PeriodicPaymentTypeValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, PaymentMapper paymentMapper, AmountValidator amountValidator, PaymentValidationConfig validationConfig) {
        super(errorBuildingService, xs2aObjectMapper, paymentMapper, amountValidator, validationConfig);
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.PERIODIC;
    }

    @Override
    public void validate(Object body, MessageError messageError) {
        try {
            this.doPeriodicValidation(this.paymentMapper.getPeriodicPayment(body), messageError);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("Unrecognized field")) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_EXTRA_FIELD, this.extractErrorField(e.getMessage())));
            }
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR));
        }
    }

    void doPeriodicValidation(PeriodicPayment periodicPayment, MessageError messageError) {
        super.doSingleValidation(periodicPayment, messageError);
        if (Objects.isNull(periodicPayment.getStartDate())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_NULL_VALUE, "startDate"));
        } else {
            this.validateStartDate(periodicPayment.getStartDate(), messageError);
        }
        if (Objects.nonNull(periodicPayment.getExecutionRule())) {
            this.checkFieldForMaxLength(periodicPayment.getExecutionRule().getValue(), "executionRule", this.validationConfig.getExecutionRule(), messageError);
        }
        if (Objects.isNull(periodicPayment.getFrequency())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_NULL_VALUE, "frequency"));
        }
        if (this.areDatesInvalidInPeriodicPayment(periodicPayment)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.PERIOD_INVALID_WRONG_ORDER));
        }
    }

    private void validateStartDate(LocalDate startDate, MessageError messageError) {
        if (startDate.isBefore(LocalDate.now())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_DATE_IN_THE_PAST, "startDate"));
        }
    }

    private boolean areDatesInvalidInPeriodicPayment(PeriodicPayment periodicPayment) {
        LocalDate paymentStartDate = periodicPayment.getStartDate();
        if (paymentStartDate == null || paymentStartDate.isBefore(LocalDate.now())) {
            return false;
        }
        LocalDate paymentEndDate = periodicPayment.getEndDate();
        return this.isDateInThePast(paymentStartDate) || Optional.ofNullable(paymentEndDate).map(dt -> dt.isBefore(paymentStartDate)).orElse(false) != false;
    }
}

