/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.xs2a.component.logger.TppLogger;
import de.adorsys.psd2.xs2a.component.logger.TppRequestLogBuilder;
import de.adorsys.psd2.xs2a.component.logger.TppResponseLogBuilder;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.context.LoggingContextService;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class ConsentLoggingInterceptor
extends HandlerInterceptorAdapter {
    private static final String NOT_EXIST_IN_URI = "Not exist in URI";
    private final TppService tppService;
    private final RedirectIdService redirectIdService;
    private final RequestProviderService requestProviderService;
    private final LoggingContextService loggingContextService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String consentId = Optional.ofNullable(pathVariables).map(pv -> (String)pv.get("consentId")).orElse(NOT_EXIST_IN_URI);
        ((TppRequestLogBuilder)((TppRequestLogBuilder)((TppRequestLogBuilder)TppLogger.logRequest(request).withTpp(this.tppService.getTppInfo()).withInternalRequestId(this.requestProviderService.getInternalRequestId())).withXRequestId()).withRequestUri().withParam("Consent ID", consentId)).perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ((TppResponseLogBuilder)((TppResponseLogBuilder)((TppResponseLogBuilder)((TppResponseLogBuilder)TppLogger.logResponse(response).withTpp(this.tppService.getTppInfo()).withInternalRequestId(this.requestProviderService.getInternalRequestId())).withXRequestId()).withResponseStatus().withOptionalRedirectId(this.redirectIdService.getRedirectId()).withParam("consentStatus", this.loggingContextService.getConsentStatus())).withParam("scaStatus", this.loggingContextService.getScaStatus())).perform();
    }

    @ConstructorProperties(value={"tppService", "redirectIdService", "requestProviderService", "loggingContextService"})
    public ConsentLoggingInterceptor(TppService tppService, RedirectIdService redirectIdService, RequestProviderService requestProviderService, LoggingContextService loggingContextService) {
        this.tppService = tppService;
        this.redirectIdService = redirectIdService;
        this.requestProviderService = requestProviderService;
        this.loggingContextService = loggingContextService;
    }
}

