/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.header;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class PaymentCancellationHeadersBuilder {
    private final ScaApproachResolver scaApproachResolver;

    public ResponseHeaders buildStartPaymentCancellationAuthorisationHeaders(@NotNull String authorisationId) {
        return this.buildHeadersForExistingAuthorisation(authorisationId);
    }

    public ResponseHeaders buildUpdatePaymentCancellationPsuDataHeaders(@NotNull String authorisationId) {
        return this.buildHeadersForExistingAuthorisation(authorisationId);
    }

    private ResponseHeaders buildHeadersForExistingAuthorisation(String authorisationId) {
        ScaApproach authorisationScaApproach = this.scaApproachResolver.getCancellationScaApproach(authorisationId);
        return this.buildScaApproachHeader(authorisationScaApproach);
    }

    private ResponseHeaders buildScaApproachHeader(ScaApproach scaApproach) {
        return ResponseHeaders.builder().aspspScaApproach(scaApproach).build();
    }

    @ConstructorProperties(value={"scaApproachResolver"})
    public PaymentCancellationHeadersBuilder(ScaApproachResolver scaApproachResolver) {
        this.scaApproachResolver = scaApproachResolver;
    }
}

