/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.filter;

import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoHolder;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageBuilder;
import de.adorsys.psd2.xs2a.web.filter.QwacCertificateFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Profile(value={"mock-qwac"})
@Component
@PropertySource(value={"classpath:qwac.properties"})
public class QwacCertificateFilterMock
extends QwacCertificateFilter {
    @Value(value="${qwac-certificate-mock}")
    private String qwacCertificateMock;

    public QwacCertificateFilterMock(TppInfoHolder tppInfoHolder, RequestProviderService requestProviderService, TppErrorMessageBuilder tppErrorMessageBuilder) {
        super(tppInfoHolder, requestProviderService, tppErrorMessageBuilder);
    }

    @Override
    public String getEncodedTppQwacCert(HttpServletRequest httpRequest) {
        String certificateInHeader = httpRequest.getHeader("tpp-qwac-certificate");
        return (String)StringUtils.defaultIfBlank((CharSequence)certificateInHeader, (CharSequence)this.qwacCertificateMock);
    }
}

