/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationServiceType;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.PisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.PisPsuDataUpdateAuthorisationCheckerValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.authorisation.AuthorisationStageCheckValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.PisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.UpdatePisPsuDataPO;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractUpdatePisPsuDataValidator<T extends UpdatePisPsuDataPO>
extends AbstractPisValidator<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractUpdatePisPsuDataValidator.class);
    private final PisEndpointAccessCheckerService pisEndpointAccessCheckerService;
    private final PisAuthorisationValidator pisAuthorisationValidator;
    private final PisAuthorisationStatusValidator pisAuthorisationStatusValidator;
    private final PisPsuDataUpdateAuthorisationCheckerValidator pisPsuDataUpdateAuthorisationCheckerValidator;
    private final AuthorisationStageCheckValidator authorisationStageCheckValidator;

    public AbstractUpdatePisPsuDataValidator(RequestProviderService requestProviderService, PisEndpointAccessCheckerService pisEndpointAccessCheckerService, PisAuthorisationValidator pisAuthorisationValidator, PisAuthorisationStatusValidator pisAuthorisationStatusValidator, PisPsuDataUpdateAuthorisationCheckerValidator pisPsuDataUpdateAuthorisationCheckerValidator, AuthorisationStageCheckValidator authorisationStageCheckValidator) {
        super(requestProviderService);
        this.pisEndpointAccessCheckerService = pisEndpointAccessCheckerService;
        this.pisAuthorisationValidator = pisAuthorisationValidator;
        this.pisAuthorisationStatusValidator = pisAuthorisationStatusValidator;
        this.pisPsuDataUpdateAuthorisationCheckerValidator = pisPsuDataUpdateAuthorisationCheckerValidator;
        this.authorisationStageCheckValidator = authorisationStageCheckValidator;
    }

    @Override
    protected ValidationResult executeBusinessValidation(UpdatePisPsuDataPO paymentObject) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = paymentObject.getUpdateRequest();
        String authorisationId = request.getAuthorisationId();
        if (!this.pisEndpointAccessCheckerService.isEndpointAccessible(authorisationId, this.getPaymentAuthorisationType())) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Authorisation ID: [{}]. Updating PIS initiation authorisation PSU Data  has failed: endpoint is not accessible for authorisation", new Object[]{this.getRequestProviderService().getInternalRequestId(), this.getRequestProviderService().getRequestId(), authorisationId});
            return ValidationResult.invalid(ErrorType.PIS_403, MessageErrorCode.SERVICE_BLOCKED);
        }
        ValidationResult transactionStatusValidationResult = this.validateTransactionStatus(paymentObject);
        if (transactionStatusValidationResult.isNotValid()) {
            return transactionStatusValidationResult;
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = paymentObject.getPisCommonPaymentResponse();
        ValidationResult authorisationValidationResult = this.pisAuthorisationValidator.validate(authorisationId, pisCommonPaymentResponse);
        if (authorisationValidationResult.isNotValid()) {
            return authorisationValidationResult;
        }
        Optional authorisationOptional = pisCommonPaymentResponse.findAuthorisationInPayment(authorisationId);
        if (!authorisationOptional.isPresent()) {
            return ValidationResult.invalid(ErrorType.PIS_403, MessageErrorCode.RESOURCE_UNKNOWN_403);
        }
        Authorisation authorisation = (Authorisation)authorisationOptional.get();
        ValidationResult validationResult = this.pisPsuDataUpdateAuthorisationCheckerValidator.validate(request.getPsuData(), authorisation.getPsuData());
        if (validationResult.isNotValid()) {
            return validationResult;
        }
        ValidationResult authorisationStatusValidationResult = this.pisAuthorisationStatusValidator.validate(authorisation.getScaStatus());
        if (authorisationStatusValidationResult.isNotValid()) {
            return authorisationStatusValidationResult;
        }
        ValidationResult authorisationStageCheckValidatorResult = this.authorisationStageCheckValidator.validate(request, authorisation.getScaStatus(), this.getAuthorisationServiceType());
        if (authorisationStageCheckValidatorResult.isNotValid()) {
            return authorisationStageCheckValidatorResult;
        }
        return ValidationResult.valid();
    }

    protected ValidationResult validateTransactionStatus(UpdatePisPsuDataPO paymentObject) {
        return ValidationResult.valid();
    }

    protected abstract AuthorisationServiceType getAuthorisationServiceType();

    protected abstract PaymentAuthorisationType getPaymentAuthorisationType();
}

