/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.authorisation;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationServiceType;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AuthorisationStageCheckValidator {
    public ValidationResult validate(@NotNull UpdateAuthorisationRequest updateRequest, @NotNull ScaStatus scaStatus, @NotNull AuthorisationServiceType authType) {
        if (scaStatus == ScaStatus.RECEIVED && updateRequest.getPsuData().isEmpty()) {
            return ValidationResult.invalid(this.resolveErrorType(authType), MessageErrorCode.SERVICE_INVALID_400);
        }
        if (scaStatus == ScaStatus.PSUIDENTIFIED && updateRequest.getPassword() == null) {
            return ValidationResult.invalid(this.resolveErrorType(authType), MessageErrorCode.SERVICE_INVALID_400);
        }
        if (scaStatus == ScaStatus.PSUAUTHENTICATED && updateRequest.getAuthenticationMethodId() == null) {
            return ValidationResult.invalid(this.resolveErrorType(authType), MessageErrorCode.SERVICE_INVALID_400);
        }
        if (scaStatus == ScaStatus.SCAMETHODSELECTED && updateRequest.getScaAuthenticationData() == null) {
            return ValidationResult.invalid(this.resolveErrorType(authType), MessageErrorCode.SERVICE_INVALID_400);
        }
        return ValidationResult.valid();
    }

    private ErrorType resolveErrorType(AuthorisationServiceType authType) {
        return authType == AuthorisationServiceType.AIS ? ErrorType.AIS_400 : ErrorType.PIS_400;
    }
}

