/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2;

import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ServiceTypeToErrorTypeMapper {
    private static final Map<ServiceType, Map<Integer, ErrorType>> serviceTypeToHttpCodeAndErrorType;

    public ErrorType mapToErrorType(ServiceType serviceType, int httpCode) {
        return Optional.ofNullable(serviceTypeToHttpCodeAndErrorType.get((Object)serviceType)).map(m -> (ErrorType)((Object)((Object)m.get(httpCode)))).orElse(null);
    }

    static {
        HashMap<Integer, ErrorType> aisHttpCodeToErrorType = new HashMap<Integer, ErrorType>();
        aisHttpCodeToErrorType.put(400, ErrorType.AIS_400);
        aisHttpCodeToErrorType.put(401, ErrorType.AIS_401);
        aisHttpCodeToErrorType.put(403, ErrorType.AIS_403);
        aisHttpCodeToErrorType.put(404, ErrorType.AIS_404);
        aisHttpCodeToErrorType.put(405, ErrorType.AIS_405);
        aisHttpCodeToErrorType.put(406, ErrorType.AIS_406);
        aisHttpCodeToErrorType.put(415, ErrorType.AIS_415);
        aisHttpCodeToErrorType.put(429, ErrorType.AIS_429);
        aisHttpCodeToErrorType.put(500, ErrorType.AIS_500);
        HashMap<Integer, ErrorType> pisHttpCodeToErrorType = new HashMap<Integer, ErrorType>();
        pisHttpCodeToErrorType.put(400, ErrorType.PIS_400);
        pisHttpCodeToErrorType.put(401, ErrorType.PIS_401);
        pisHttpCodeToErrorType.put(403, ErrorType.PIS_403);
        pisHttpCodeToErrorType.put(404, ErrorType.PIS_404);
        pisHttpCodeToErrorType.put(405, ErrorType.PIS_405);
        pisHttpCodeToErrorType.put(406, ErrorType.PIS_406);
        pisHttpCodeToErrorType.put(409, ErrorType.PIS_409);
        pisHttpCodeToErrorType.put(415, ErrorType.PIS_415);
        pisHttpCodeToErrorType.put(500, ErrorType.PIS_500);
        HashMap<Integer, ErrorType> piisHttpCodeToErrorType = new HashMap<Integer, ErrorType>();
        piisHttpCodeToErrorType.put(400, ErrorType.PIIS_400);
        piisHttpCodeToErrorType.put(401, ErrorType.PIIS_401);
        piisHttpCodeToErrorType.put(403, ErrorType.PIIS_403);
        piisHttpCodeToErrorType.put(404, ErrorType.PIIS_404);
        piisHttpCodeToErrorType.put(405, ErrorType.PIIS_405);
        piisHttpCodeToErrorType.put(409, ErrorType.PIIS_409);
        piisHttpCodeToErrorType.put(415, ErrorType.PIIS_415);
        piisHttpCodeToErrorType.put(500, ErrorType.PIIS_500);
        HashMap<Integer, ErrorType> sbHttpCodeToErrorType = new HashMap<Integer, ErrorType>();
        sbHttpCodeToErrorType.put(400, ErrorType.SB_400);
        sbHttpCodeToErrorType.put(401, ErrorType.SB_401);
        sbHttpCodeToErrorType.put(403, ErrorType.SB_403);
        sbHttpCodeToErrorType.put(404, ErrorType.SB_404);
        sbHttpCodeToErrorType.put(405, ErrorType.SB_405);
        sbHttpCodeToErrorType.put(409, ErrorType.SB_409);
        sbHttpCodeToErrorType.put(415, ErrorType.SB_415);
        sbHttpCodeToErrorType.put(500, ErrorType.SB_500);
        serviceTypeToHttpCodeAndErrorType = new EnumMap<ServiceType, Map<Integer, ErrorType>>(ServiceType.class);
        serviceTypeToHttpCodeAndErrorType.put(ServiceType.AIS, aisHttpCodeToErrorType);
        serviceTypeToHttpCodeAndErrorType.put(ServiceType.PIS, pisHttpCodeToErrorType);
        serviceTypeToHttpCodeAndErrorType.put(ServiceType.PIIS, piisHttpCodeToErrorType);
        serviceTypeToHttpCodeAndErrorType.put(ServiceType.SB, sbHttpCodeToErrorType);
    }
}

