/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScaApproachResolver {
    private static final Logger log = LoggerFactory.getLogger(ScaApproachResolver.class);
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final Xs2aAisConsentService xs2aAisConsentService;
    private final PisAuthorisationService pisAuthorisationService;
    private final AspspProfileService aspspProfileService;
    private final RequestProviderService requestProviderService;

    public ScaApproachResolver(ServiceTypeDiscoveryService serviceTypeDiscoveryService, @Lazy Xs2aAisConsentService xs2aAisConsentService, @Lazy PisAuthorisationService pisAuthorisationService, AspspProfileService aspspProfileService, RequestProviderService requestProviderService) {
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.xs2aAisConsentService = xs2aAisConsentService;
        this.pisAuthorisationService = pisAuthorisationService;
        this.aspspProfileService = aspspProfileService;
        this.requestProviderService = requestProviderService;
    }

    public ScaApproach resolveScaApproach() {
        List scaApproaches = this.aspspProfileService.getScaApproaches();
        ScaApproach firstScaApproach = this.getFirst(scaApproaches);
        Optional<Boolean> tppRedirectPreferredOptional = this.requestProviderService.resolveTppRedirectPreferred();
        if (!tppRedirectPreferredOptional.isPresent()) {
            return firstScaApproach;
        }
        boolean tppRedirectPreferred = tppRedirectPreferredOptional.get();
        if (tppRedirectPreferred && scaApproaches.contains(ScaApproach.REDIRECT)) {
            return ScaApproach.REDIRECT;
        }
        if (!tppRedirectPreferred && ScaApproach.REDIRECT == firstScaApproach && scaApproaches.size() > 1) {
            return this.getSecond(scaApproaches);
        }
        return firstScaApproach;
    }

    @NotNull
    public ScaApproach getInitiationScaApproach(@NotNull String authorisationId) {
        return this.resolveScaApproach(authorisationId, PaymentAuthorisationType.CREATED);
    }

    @NotNull
    public ScaApproach getCancellationScaApproach(@NotNull String authorisationId) {
        return this.resolveScaApproach(authorisationId, PaymentAuthorisationType.CANCELLED);
    }

    @NotNull
    private ScaApproach resolveScaApproach(@NotNull String authorisationId, PaymentAuthorisationType authorisationType) {
        Optional<Object> scaApproachResponse = Optional.empty();
        ServiceType serviceType = this.serviceTypeDiscoveryService.getServiceType();
        if (serviceType == ServiceType.AIS) {
            scaApproachResponse = this.xs2aAisConsentService.getAuthorisationScaApproach(authorisationId);
        } else if (serviceType == ServiceType.PIS) {
            scaApproachResponse = this.pisAuthorisationService.getAuthorisationScaApproach(authorisationId, authorisationType);
        }
        if (!scaApproachResponse.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}]. Couldn't retrieve SCA approach from the authorisation with id: {} and type: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), authorisationId, authorisationType});
            throw new IllegalArgumentException("Wrong authorisation id: " + authorisationId + " or type: " + authorisationType);
        }
        return ((AuthorisationScaApproachResponse)scaApproachResponse.get()).getScaApproach();
    }

    private ScaApproach getFirst(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(0);
    }

    private ScaApproach getSecond(List<ScaApproach> scaApproaches) {
        return scaApproaches.get(1);
    }
}

