/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.PaymentAuthorisationService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.PisPsuDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.context.LoggingContextService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.CommonPaymentObject;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.CreatePisAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationScaStatusPO;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationScaStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.GetPaymentInitiationAuthorisationsValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePisCommonPaymentPsuDataPO;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePisCommonPaymentPsuDataValidator;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentAuthorisationServiceImpl
implements PaymentAuthorisationService {
    private static final Logger log = LoggerFactory.getLogger(PaymentAuthorisationServiceImpl.class);
    private final Xs2aEventService xs2aEventService;
    private final PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final CreatePisAuthorisationValidator createPisAuthorisationValidator;
    private final UpdatePisCommonPaymentPsuDataValidator updatePisCommonPaymentPsuDataValidator;
    private final GetPaymentInitiationAuthorisationsValidator getPaymentAuthorisationsValidator;
    private final GetPaymentInitiationAuthorisationScaStatusValidator getPaymentAuthorisationScaStatusValidator;
    private final RequestProviderService requestProviderService;
    private final PisPsuDataService pisPsuDataService;
    private final LoggingContextService loggingContextService;

    @Override
    public ResponseObject<AuthorisationResponse> createPisAuthorisation(Xs2aCreatePisAuthorisationRequest createRequest) {
        ResponseObject<Xs2aCreatePisAuthorisationResponse> createPisAuthorisationResponse = this.createPisAuthorisation(createRequest.getPaymentId(), createRequest.getPaymentService(), createRequest.getPaymentProduct(), createRequest.getPsuData());
        if (createPisAuthorisationResponse.hasError()) {
            return ResponseObject.builder().fail(createPisAuthorisationResponse.getError()).build();
        }
        if (createRequest.getPsuData().isEmpty() || StringUtils.isBlank((CharSequence)createRequest.getPassword())) {
            return ResponseObject.builder().body(createPisAuthorisationResponse.getBody()).build();
        }
        String authorisationId = createPisAuthorisationResponse.getBody().getAuthorisationId();
        Xs2aUpdatePisCommonPaymentPsuDataRequest updateRequest = new Xs2aUpdatePisCommonPaymentPsuDataRequest(createRequest, authorisationId);
        ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePsuDataResponse = this.updatePisCommonPaymentPsuData(updateRequest);
        if (updatePsuDataResponse.hasError()) {
            return ResponseObject.builder().fail(updatePsuDataResponse.getError()).build();
        }
        return ResponseObject.builder().body(updatePsuDataResponse.getBody()).build();
    }

    @Override
    public ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> updatePisCommonPaymentPsuData(Xs2aUpdatePisCommonPaymentPsuDataRequest request) {
        this.xs2aEventService.recordPisTppRequest(request.getPaymentId(), EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_REQUEST_RECEIVED, request);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(request.getPaymentId());
        if (!pisCommonPaymentResponse.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Update PIS CommonPayment PSU data failed. PIS CommonPayment not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getPaymentId()});
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPayment = pisCommonPaymentResponse.get();
        ValidationResult validationResult = this.updatePisCommonPaymentPsuDataValidator.validate(new UpdatePisCommonPaymentPsuDataPO(pisCommonPayment, request));
        if (validationResult.isNotValid()) {
            if (validationResult.getMessageError().getTppMessage().getMessageErrorCode() == MessageErrorCode.PSU_CREDENTIALS_INVALID) {
                this.pisCommonPaymentService.updatePisAuthorisationStatus(request.getAuthorisationId(), ScaStatus.FAILED);
            }
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Update PIS CommonPayment PSU data - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getPaymentId(), validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        this.loggingContextService.storeTransactionStatus(pisCommonPayment.getTransactionStatus());
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getServiceInitiation(request.getAuthorisationId());
        Xs2aUpdatePisCommonPaymentPsuDataResponse response = pisScaAuthorisationService.updateCommonPaymentPsuData(request);
        if (response.hasError()) {
            return ResponseObject.builder().fail(new MessageError(response.getErrorHolder())).build();
        }
        this.loggingContextService.storeScaStatus(response.getScaStatus());
        return ResponseObject.builder().body(response).build();
    }

    @Override
    public ResponseObject<Xs2aAuthorisationSubResources> getPaymentInitiationAuthorisations(String paymentId, String paymentProduct, PaymentType paymentType) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponse.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Get Payment authorisation failed. PIS CommonPayment not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId});
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        ValidationResult validationResult = this.getPaymentAuthorisationsValidator.validate(new CommonPaymentObject(pisCommonPaymentResponse.get(), paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Get payment initiation authorisation - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        this.loggingContextService.storeTransactionStatus(pisCommonPaymentResponse.get().getTransactionStatus());
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        return pisScaAuthorisationService.getAuthorisationSubResources(paymentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(() -> {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Get payment initiation authorisation has failed. Authorisation not found by payment id.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId});
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        });
    }

    @Override
    public ResponseObject<ScaStatus> getPaymentInitiationAuthorisationScaStatus(String paymentId, String authorisationId, PaymentType paymentType, String paymentProduct) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponseOptional = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponseOptional.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Get SCA status payment initiation authorisation failed. PIS CommonPayment not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId});
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentResponseOptional.get();
        ValidationResult validationResult = this.getPaymentAuthorisationScaStatusValidator.validate(new GetPaymentInitiationAuthorisationScaStatusPO(pisCommonPaymentResponse, authorisationId, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Get SCA status payment initiation authorisation - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getServiceInitiation(authorisationId);
        Optional<ScaStatus> scaStatusOptional = pisScaAuthorisationService.getAuthorisationScaStatus(paymentId, authorisationId);
        if (!scaStatusOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        ScaStatus scaStatus = scaStatusOptional.get();
        this.loggingContextService.storeTransactionAndScaStatus(pisCommonPaymentResponse.getTransactionStatus(), scaStatus);
        return ResponseObject.builder().body(scaStatus).build();
    }

    private ResponseObject<Xs2aCreatePisAuthorisationResponse> createPisAuthorisation(String paymentId, PaymentType paymentService, String paymentProduct, PsuIdData psuDataFromRequest) {
        ValidationResult validationResult;
        Optional psuIdDataFromDb;
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.START_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentResponse = this.pisCommonPaymentService.getPisCommonPaymentById(paymentId);
        if (!pisCommonPaymentResponse.isPresent()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Create PIS Authorisation failed. PIS CommonPayment not found by id", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId});
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404_NO_PAYMENT)).build();
        }
        PisCommonPaymentResponse pisCommonPayment = pisCommonPaymentResponse.get();
        boolean isMultilevel = pisCommonPayment.isMultilevelScaRequired();
        PsuIdData psuIdData = psuDataFromRequest;
        if (psuDataFromRequest.isEmpty() && !isMultilevel && (psuIdDataFromDb = this.pisPsuDataService.getPsuDataByPaymentId(paymentId).stream().findFirst()).isPresent()) {
            psuIdData = (PsuIdData)psuIdDataFromDb.get();
        }
        if ((validationResult = this.createPisAuthorisationValidator.validate(new CommonPaymentObject(pisCommonPayment, paymentService, paymentProduct))).isNotValid()) {
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. Create PIS Authorisation - validation failed: {}", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
        Optional<Xs2aCreatePisAuthorisationResponse> commonPaymentAuthorisation = pisScaAuthorisationService.createCommonPaymentAuthorisation(paymentId, paymentService, psuIdData);
        if (!commonPaymentAuthorisation.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.PAYMENT_FAILED)).build();
        }
        Xs2aCreatePisAuthorisationResponse createAuthorisationResponse = commonPaymentAuthorisation.get();
        this.loggingContextService.storeTransactionAndScaStatus(pisCommonPayment.getTransactionStatus(), createAuthorisationResponse.getScaStatus());
        return ResponseObject.builder().body(createAuthorisationResponse).build();
    }

    @ConstructorProperties(value={"xs2aEventService", "pisScaAuthorisationServiceResolver", "pisCommonPaymentService", "createPisAuthorisationValidator", "updatePisCommonPaymentPsuDataValidator", "getPaymentAuthorisationsValidator", "getPaymentAuthorisationScaStatusValidator", "requestProviderService", "pisPsuDataService", "loggingContextService"})
    public PaymentAuthorisationServiceImpl(Xs2aEventService xs2aEventService, PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver, Xs2aPisCommonPaymentService pisCommonPaymentService, CreatePisAuthorisationValidator createPisAuthorisationValidator, UpdatePisCommonPaymentPsuDataValidator updatePisCommonPaymentPsuDataValidator, GetPaymentInitiationAuthorisationsValidator getPaymentAuthorisationsValidator, GetPaymentInitiationAuthorisationScaStatusValidator getPaymentAuthorisationScaStatusValidator, RequestProviderService requestProviderService, PisPsuDataService pisPsuDataService, LoggingContextService loggingContextService) {
        this.xs2aEventService = xs2aEventService;
        this.pisScaAuthorisationServiceResolver = pisScaAuthorisationServiceResolver;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.createPisAuthorisationValidator = createPisAuthorisationValidator;
        this.updatePisCommonPaymentPsuDataValidator = updatePisCommonPaymentPsuDataValidator;
        this.getPaymentAuthorisationsValidator = getPaymentAuthorisationsValidator;
        this.getPaymentAuthorisationScaStatusValidator = getPaymentAuthorisationScaStatusValidator;
        this.requestProviderService = requestProviderService;
        this.pisPsuDataService = pisPsuDataService;
        this.loggingContextService = loggingContextService;
    }
}

