/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;

public class ResponseObject<T> {
    private final T body;
    private final MessageError error;

    private ResponseObject(ResponseBuilder<T> builder) {
        this.body = ((ResponseBuilder)builder).body;
        this.error = ((ResponseBuilder)builder).error;
    }

    public static <T> ResponseBuilder<T> builder() {
        return new ResponseBuilder();
    }

    public boolean hasError() {
        return this.error != null;
    }

    public T getBody() {
        return this.body;
    }

    public MessageError getError() {
        return this.error;
    }

    public static class ResponseBuilder<T> {
        private T body;
        private MessageError error;

        private ResponseBuilder() {
        }

        public ResponseBuilder<T> body(T body) {
            this.body = body;
            return this;
        }

        public ResponseBuilder<T> fail(MessageError error) {
            this.error = error;
            return this;
        }

        public ResponseBuilder<T> fail(ErrorType errorType, TppMessageInformation ... tppMessageInformation) {
            this.error = new MessageError(errorType, tppMessageInformation);
            return this;
        }

        public ResponseBuilder<T> fail(ErrorHolder errorHolder) {
            this.error = new MessageError(errorHolder);
            return this;
        }

        public ResponseObject<T> build() {
            return new ResponseObject(this);
        }
    }
}

