package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-10-11T17:06:00+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class SpiToXs2aSinglePaymentMapperImpl implements SpiToXs2aSinglePaymentMapper {

    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aAddressMapper spiToXs2aAddressMapper;
    @Autowired
    private RemittanceMapper remittanceMapper;

    @Override
    public SinglePayment mapToXs2aSinglePayment(SpiSinglePayment payment) {
        if ( payment == null ) {
            return null;
        }

        SinglePayment singlePayment = new SinglePayment();

        singlePayment.setTransactionStatus( payment.getPaymentStatus() );
        singlePayment.setPaymentId( payment.getPaymentId() );
        singlePayment.setPaymentProduct( payment.getPaymentProduct() );
        singlePayment.setStatusChangeTimestamp( payment.getStatusChangeTimestamp() );
        singlePayment.setCreditorId( payment.getCreditorId() );
        singlePayment.setEndToEndIdentification( payment.getEndToEndIdentification() );
        singlePayment.setDebtorAccount( spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( payment.getDebtorAccount() ) );
        singlePayment.setUltimateDebtor( payment.getUltimateDebtor() );
        singlePayment.setInstructedAmount( spiToXs2aAmountMapper.mapToXs2aAmount( payment.getInstructedAmount() ) );
        singlePayment.setCreditorAccount( spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( payment.getCreditorAccount() ) );
        singlePayment.setCreditorAgent( payment.getCreditorAgent() );
        singlePayment.setCreditorName( payment.getCreditorName() );
        singlePayment.setCreditorAddress( spiToXs2aAddressMapper.mapToAddress( payment.getCreditorAddress() ) );
        singlePayment.setUltimateCreditor( payment.getUltimateCreditor() );
        singlePayment.setPurposeCode( payment.getPurposeCode() );
        singlePayment.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        singlePayment.setRemittanceInformationStructured( remittanceMapper.mapToRemittance( payment.getRemittanceInformationStructured() ) );
        singlePayment.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        singlePayment.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        singlePayment.setPaymentType( payment.getPaymentType() );

        return singlePayment;
    }

    @Override
    public List<SinglePayment> mapToXs2aSinglePaymentList(List<SpiSinglePayment> payments) {
        if ( payments == null ) {
            return new ArrayList<SinglePayment>();
        }

        List<SinglePayment> list = new ArrayList<SinglePayment>( payments.size() );
        for ( SpiSinglePayment spiSinglePayment : payments ) {
            list.add( mapToXs2aSinglePayment( spiSinglePayment ) );
        }

        return list;
    }
}
