/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.query;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.query.QueryParameterValidator;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractQueryParameterValidatorImpl
implements QueryParameterValidator {
    protected final ErrorBuildingService errorBuildingService;

    protected ValidationResult validateMandatoryParameterPresence(Map<String, List<String>> queryParameterMap) {
        List<String> queryParameterValues = this.getQueryParameterValues(queryParameterMap);
        String queryParameterName = this.getQueryParameterName();
        if (queryParameterValues.isEmpty()) {
            return ValidationResult.invalid(this.errorBuildingService.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_ABSENT_PARAMETER, queryParameterName));
        }
        if (this.hasMultipleValues(queryParameterValues)) {
            return ValidationResult.invalid(this.errorBuildingService.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_INVALID_PARAMETER_VALUE, queryParameterName));
        }
        String queryParameterValue = this.getQueryParameterValue(queryParameterMap);
        if (StringUtils.isBlank((CharSequence)queryParameterValue)) {
            return ValidationResult.invalid(this.errorBuildingService.buildErrorType(), TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_BLANK_PARAMETER, queryParameterName));
        }
        return ValidationResult.valid();
    }

    protected abstract String getQueryParameterName();

    protected String getQueryParameterValue(Map<String, List<String>> queryParameterMap) {
        List<String> queryParameterValues = this.getQueryParameterValues(queryParameterMap);
        return queryParameterValues.stream().findFirst().orElse(null);
    }

    private List<String> getQueryParameterValues(Map<String, List<String>> queryParameterMap) {
        List<String> valuesList = queryParameterMap.get(this.getQueryParameterName());
        return Optional.ofNullable(valuesList).orElseGet(ArrayList::new);
    }

    private boolean hasMultipleValues(List<String> queryParameterValues) {
        return queryParameterValues.size() > 1;
    }

    @ConstructorProperties(value={"errorBuildingService"})
    public AbstractQueryParameterValidatorImpl(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }
}

