/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.path;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class PaymentTypeAndProductValidator {
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    @NotNull
    public ValidationResult validateTypeAndProduct(@NotNull PaymentType paymentType, String paymentProduct) {
        Map<PaymentType, Set<String>> supportedPaymentTypeAndProductMatrix = this.aspspProfileServiceWrapper.getSupportedPaymentTypeAndProductMatrix();
        if (supportedPaymentTypeAndProductMatrix.containsKey(paymentType)) {
            if (supportedPaymentTypeAndProductMatrix.get(paymentType).contains(paymentProduct)) {
                return ValidationResult.valid();
            }
            return ValidationResult.invalid(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.PRODUCT_UNKNOWN_WRONG_PAYMENT_PRODUCT, paymentProduct));
        }
        return ValidationResult.invalid(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.PARAMETER_NOT_SUPPORTED_WRONG_PAYMENT_TYPE, paymentType.getValue()));
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper"})
    public PaymentTypeAndProductValidator(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

