/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aHeaderConstant;
import de.adorsys.psd2.xs2a.web.validator.header.AbstractHeaderValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.header.ConsentHeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.header.PaymentHeaderValidator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HeadersLengthValidatorImpl
extends AbstractHeaderValidatorImpl
implements ConsentHeaderValidator,
PaymentHeaderValidator {
    @Autowired
    public HeadersLengthValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getHeaderName() {
        return null;
    }

    @Override
    public MessageError validate(Map<String, String> inputHeaders, MessageError messageError) {
        for (Map.Entry<String, String> header : inputHeaders.entrySet()) {
            if (!this.isHeaderExceedsLength(header)) continue;
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR_OVERSIZE_HEADER, header.getKey(), Xs2aHeaderConstant.HEADERS_MAX_LENGTHS.get(header.getKey())));
        }
        return messageError;
    }

    private boolean isHeaderExceedsLength(Map.Entry<String, String> header) {
        String headerName = header.getKey();
        String headerValue = header.getValue();
        if (headerName == null || headerValue == null) {
            return false;
        }
        String headerNameLowerCase = headerName.toLowerCase();
        Set<String> headersToValidate = Xs2aHeaderConstant.HEADERS_MAX_LENGTHS.keySet();
        return headersToValidate.contains(headerNameLowerCase) && headerValue.length() > Xs2aHeaderConstant.HEADERS_MAX_LENGTHS.get(headerNameLowerCase);
    }
}

