/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.xs2a.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.domain.address.Xs2aCountryCode;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import org.springframework.stereotype.Component;

@Component
public class Xs2aAddressMapperImpl
implements Xs2aAddressMapper {
    @Override
    public Xs2aAddress mapToXs2aAddress(Address address) {
        if (address == null) {
            return null;
        }
        Xs2aAddress xs2aAddress = new Xs2aAddress();
        xs2aAddress.setCountry(this.mapToXs2aCountryCode(address));
        xs2aAddress.setStreetName(address.getStreetName());
        xs2aAddress.setBuildingNumber(address.getBuildingNumber());
        xs2aAddress.setTownName(address.getTownName());
        xs2aAddress.setPostCode(address.getPostCode());
        return xs2aAddress;
    }

    @Override
    public Address mapToAddress(Xs2aAddress address) {
        if (address == null) {
            return null;
        }
        Address address1 = new Address();
        address1.setCountry(this.addressCountryCode(address));
        address1.setStreetName(address.getStreetName());
        address1.setBuildingNumber(address.getBuildingNumber());
        address1.setTownName(address.getTownName());
        address1.setPostCode(address.getPostCode());
        return address1;
    }

    private String addressCountryCode(Xs2aAddress xs2aAddress) {
        if (xs2aAddress == null) {
            return null;
        }
        Xs2aCountryCode country = xs2aAddress.getCountry();
        if (country == null) {
            return null;
        }
        String code = country.getCode();
        if (code == null) {
            return null;
        }
        return code;
    }
}

